/*
 * Decompiled with CFR 0.152.
 */
package openllet.query.sparqldl.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import openllet.aterm.ATermAppl;
import openllet.atom.OpenError;
import openllet.core.KnowledgeBase;
import openllet.core.OpenlletOptions;
import openllet.core.exceptions.InternalReasonerException;
import openllet.core.exceptions.UnsupportedQueryException;
import openllet.core.taxonomy.Taxonomy;
import openllet.core.taxonomy.TaxonomyNode;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.CandidateSet;
import openllet.core.utils.DisjointSet;
import openllet.core.utils.TermFactory;
import openllet.core.utils.Timer;
import openllet.query.sparqldl.engine.BindingIterator;
import openllet.query.sparqldl.engine.CoreStrategy;
import openllet.query.sparqldl.engine.LiteralIterator;
import openllet.query.sparqldl.engine.QueryEngine;
import openllet.query.sparqldl.engine.QueryExec;
import openllet.query.sparqldl.engine.QueryOptimizer;
import openllet.query.sparqldl.engine.QueryPlan;
import openllet.query.sparqldl.model.CoreNewImpl;
import openllet.query.sparqldl.model.NotKnownQueryAtom;
import openllet.query.sparqldl.model.Query;
import openllet.query.sparqldl.model.QueryAtom;
import openllet.query.sparqldl.model.QueryAtomFactory;
import openllet.query.sparqldl.model.QueryImpl;
import openllet.query.sparqldl.model.QueryPredicate;
import openllet.query.sparqldl.model.QueryResult;
import openllet.query.sparqldl.model.QueryResultImpl;
import openllet.query.sparqldl.model.ResultBinding;
import openllet.query.sparqldl.model.ResultBindingImpl;
import openllet.query.sparqldl.model.UnionQueryAtom;
import openllet.shared.tools.Log;

public class CombinedQueryEngine
implements QueryExec {
    public static final Logger _logger = Log.getLogger(CombinedQueryEngine.class);
    public static final QueryOptimizer _optimizer = new QueryOptimizer();
    private KnowledgeBase _kb;
    protected QueryPlan _plan;
    protected Query _oldQuery;
    protected Query _query;
    private QueryResult _result;
    private Set<ATermAppl> _downMonotonic;
    private long branches;
    private final boolean STOP_ROLLING_ON_CONSTANTS = false;

    private void prepare(Query query2) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Preparing plan ...");
        }
        this._kb = query2.getKB();
        if (this._kb == null) {
            throw new OpenError("No input data set is given for query!");
        }
        this._result = new QueryResultImpl(query2);
        this._oldQuery = query2;
        this._query = this.setupCores(query2);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("After setting-up cores : " + this._query);
        }
        this._plan = _optimizer.getExecutionPlan(this._query);
        this._plan.reset();
        if (OpenlletOptions.USE_CACHING && !this._kb.isClassified()) {
            for (QueryAtom a : this._oldQuery.getAtoms()) {
                for (ATermAppl arg : a.getArguments()) {
                    if (!this._kb.isClass(arg)) continue;
                    this._kb.isSatisfiable(arg);
                    this._kb.isSatisfiable(ATermUtils.makeNot(arg));
                }
            }
        }
        if (OpenlletOptions.OPTIMIZE_DOWN_MONOTONIC) {
            this._downMonotonic = new HashSet<ATermAppl>();
            this.setupDownMonotonicVariables(this._query);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Variables to be optimized : " + this._downMonotonic);
            }
        }
    }

    private Query setupCores(Query query2) {
        Iterator<ATermAppl> undistVarIterator = query2.getUndistVars().iterator();
        if (!undistVarIterator.hasNext()) {
            return query2;
        }
        DisjointSet<Object> coreVertices = new DisjointSet<Object>();
        ArrayList<QueryAtom> toRemove = new ArrayList<QueryAtom>();
        while (undistVarIterator.hasNext()) {
            ATermAppl a2;
            ATermAppl a = undistVarIterator.next();
            coreVertices.add(a);
            for (QueryAtom atom : query2.findAtoms(QueryPredicate.PropertyValue, a, null, null)) {
                coreVertices.add(atom);
                coreVertices.union(a, atom);
                a2 = atom.getArguments().get(2);
                if (query2.getUndistVars().contains(a2)) {
                    coreVertices.add(a2);
                    coreVertices.union(a, a2);
                }
                toRemove.add(atom);
            }
            for (QueryAtom atom : query2.findAtoms(QueryPredicate.PropertyValue, null, null, a)) {
                coreVertices.add(atom);
                coreVertices.union(a, atom);
                a2 = atom.getArguments().get(0);
                if (query2.getUndistVars().contains(a2)) {
                    coreVertices.add(a2);
                    coreVertices.union(a, a2);
                }
                toRemove.add(atom);
            }
            for (QueryAtom atom : query2.findAtoms(QueryPredicate.Type, a, null)) {
                coreVertices.add(atom);
                coreVertices.union(a, atom);
                toRemove.add(atom);
            }
        }
        Query transformedQuery = query2.apply(new ResultBindingImpl());
        for (Set set : coreVertices.getEquivalanceSets()) {
            ArrayList<QueryAtom> atoms = new ArrayList<QueryAtom>();
            for (Object a : set) {
                if (!(a instanceof QueryAtom)) continue;
                atoms.add((QueryAtom)a);
            }
            CoreNewImpl c = (CoreNewImpl)QueryAtomFactory.Core(atoms, query2.getUndistVars(), this._kb);
            transformedQuery.add(c);
            _logger.fine(() -> c.getUndistVars() + " : " + c.getDistVars() + " : " + c.getQuery().getAtoms());
        }
        for (QueryAtom atom : toRemove) {
            transformedQuery.remove(atom);
        }
        return transformedQuery;
    }

    private void setupDownMonotonicVariables(Query query2) {
        block3: for (QueryAtom atom : query2.getAtoms()) {
            switch (atom.getPredicate()) {
                case PropertyValue: 
                case Type: {
                    ATermAppl arg = atom.getArguments().get(1);
                    if (!ATermUtils.isVar(arg)) continue block3;
                    this._downMonotonic.add(arg);
                    continue block3;
                }
            }
            Object var4_4 = null;
        }
    }

    @Override
    public boolean supports(Query q) {
        return true;
    }

    @Override
    public QueryResult exec(Query query2) {
        _logger.fine(() -> "Executing query " + query2);
        Timer timer = new Timer("CombinedQueryEngine");
        timer.start();
        this.prepare(query2);
        this.branches = 0L;
        this.exec(new ResultBindingImpl());
        timer.stop();
        _logger.fine(() -> "#B=" + this.branches + ", time=" + timer.getLast() + " ms.");
        return this._result;
    }

    private void exec(ResultBinding bindingParam) {
        ResultBinding binding = bindingParam;
        if (_logger.isLoggable(Level.FINE)) {
            ++this.branches;
        }
        if (!this._plan.hasNext()) {
            if (!binding.isEmpty() || this._result.isEmpty()) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("Found binding: " + binding);
                }
                if (!this._result.getResultVars().containsAll(binding.getAllVariables())) {
                    ResultBindingImpl newBinding = new ResultBindingImpl();
                    for (ATermAppl var : this._result.getResultVars()) {
                        ATermAppl value = binding.getValue(var);
                        newBinding.setValue(var, value);
                    }
                    binding = newBinding;
                }
                this._result.add(binding);
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.finer("Returning ... binding=" + binding);
            }
            return;
        }
        QueryAtom current = this._plan.next(binding);
        _logger.finer(() -> "Evaluating " + current);
        if (current.isGround() && !current.getPredicate().equals((Object)QueryPredicate.UndistVarCore)) {
            if (QueryEngine.checkGround(current, this._kb)) {
                this.exec(binding);
            }
        } else {
            this.exec(current, binding);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.finer("Returning ... " + binding);
        }
        this._plan.back();
    }

    private void exec(QueryAtom current, ResultBinding binding) {
        List<ATermAppl> arguments = current.getArguments();
        boolean direct = false;
        boolean strict = false;
        block0 : switch (current.getPredicate()) {
            case DirectType: {
                direct = true;
            }
            case Type: {
                ATermAppl tI = arguments.get(0);
                ATermAppl tC = arguments.get(1);
                Set<ATermAppl> instanceCandidates = null;
                if (tI.equals(tC)) {
                    instanceCandidates = this._kb.getIndividualsCount() < this._kb.getClasses().size() ? this._kb.getIndividuals() : this._kb.getClasses();
                    for (ATermAppl ic : instanceCandidates) {
                        if (!(direct ? this._kb.getInstances(ic, direct).contains(ic) : this._kb.isType(ic, ic))) continue;
                        ResultBinding candidateBinding = binding.duplicate();
                        if (ATermUtils.isVar(tI)) {
                            candidateBinding.setValue(tI, ic);
                        }
                        this.exec(candidateBinding);
                    }
                } else {
                    Set<ATermAppl> classCandidates;
                    if (!ATermUtils.isVar(tC)) {
                        classCandidates = Collections.singleton(tC);
                        instanceCandidates = this._kb.getInstances(tC, direct);
                    } else if (!ATermUtils.isVar(tI)) {
                        classCandidates = this.flatten(this._kb.getTypes(tI, direct));
                        instanceCandidates = Collections.singleton(tI);
                    } else {
                        classCandidates = this._kb.getAllClasses();
                    }
                    boolean loadInstances = instanceCandidates == null;
                    for (ATermAppl cls : classCandidates) {
                        if (loadInstances) {
                            instanceCandidates = this._kb.getInstances(cls, direct);
                        }
                        if (instanceCandidates == null) continue;
                        for (ATermAppl inst : instanceCandidates) {
                            this.runNext(binding, arguments, inst, cls);
                        }
                    }
                }
                break;
            }
            case PropertyValue: {
                ATermAppl pvI = arguments.get(0);
                ATermAppl pvP = arguments.get(1);
                ATermAppl pvIL = arguments.get(2);
                Set<ATermAppl> propertyCandidates = null;
                Collection<ATermAppl> subjectCandidates = null;
                Collection<ATermAppl> objectCandidates = null;
                boolean loadProperty = false;
                boolean loadSubjects = false;
                boolean loadObjects = false;
                if (!ATermUtils.isVar(pvP)) {
                    propertyCandidates = Collections.singleton(pvP);
                    if (!ATermUtils.isVar(pvI)) {
                        subjectCandidates = Collections.singleton(pvI);
                        objectCandidates = this._kb.getPropertyValues(pvP, pvI);
                    } else if (!ATermUtils.isVar(pvIL)) {
                        objectCandidates = Collections.singleton(pvIL);
                        subjectCandidates = this._kb.getIndividualsWithProperty(pvP, pvIL);
                    }
                    loadProperty = false;
                } else {
                    if (!ATermUtils.isVar(pvI)) {
                        subjectCandidates = Collections.singleton(pvI);
                    }
                    if (!ATermUtils.isVar(pvIL)) {
                        objectCandidates = Collections.singleton(pvIL);
                    } else if (!this._plan.getQuery().getDistVarsForType(Query.VarType.LITERAL).contains(pvIL)) {
                        propertyCandidates = this._kb.getObjectProperties();
                    }
                    if (propertyCandidates == null) {
                        propertyCandidates = this._kb.getProperties();
                    }
                    loadProperty = true;
                }
                loadSubjects = subjectCandidates == null;
                loadObjects = objectCandidates == null;
                for (ATermAppl property : propertyCandidates) {
                    if (loadObjects && loadSubjects) {
                        if (pvI.equals(pvIL)) {
                            if (pvI.equals(pvP)) {
                                if (!this._kb.hasPropertyValue(property, property, property)) continue;
                                this.runNext(binding, arguments, property, property, property);
                                continue;
                            }
                            for (ATermAppl i : this._kb.getIndividuals()) {
                                if (!this._kb.hasPropertyValue(i, property, i)) continue;
                                this.runNext(binding, arguments, i, property, i);
                            }
                            continue;
                        }
                        if (pvI.equals(pvP)) {
                            for (ATermAppl i : this._kb.getIndividuals()) {
                                if (!this._kb.hasPropertyValue(property, property, i)) continue;
                                this.runNext(binding, arguments, property, property, i);
                            }
                            continue;
                        }
                        if (pvIL.equals(pvP)) {
                            for (ATermAppl i : this._kb.getIndividuals()) {
                                if (!this._kb.hasPropertyValue(i, property, property)) continue;
                                this.runNext(binding, arguments, i, property, property);
                            }
                            continue;
                        }
                        for (ATermAppl subject : this._kb.getIndividuals()) {
                            for (ATermAppl object : this._kb.getPropertyValues(property, subject)) {
                                this.runNext(binding, arguments, subject, property, object);
                            }
                        }
                        continue;
                    }
                    if (loadObjects) {
                        if (pvP.equals(pvIL) && subjectCandidates != null && !this._kb.hasPropertyValue(subjectCandidates.iterator().next(), property, property)) {
                            subjectCandidates = Collections.emptySet();
                        }
                        if (subjectCandidates == null) continue;
                        for (ATermAppl subject : subjectCandidates) {
                            for (ATermAppl object : this._kb.getPropertyValues(property, subject)) {
                                this.runNext(binding, arguments, subject, property, object);
                            }
                        }
                        continue;
                    }
                    if (objectCandidates == null) continue;
                    for (ATermAppl object : objectCandidates) {
                        if (loadSubjects) {
                            subjectCandidates = pvI.equals(pvP) ? (this._kb.hasPropertyValue(property, property, object) ? Collections.singleton(property) : Collections.emptySet()) : new HashSet<ATermAppl>(this._kb.getIndividualsWithProperty(property, object));
                        }
                        if (subjectCandidates == null) continue;
                        for (ATermAppl subject : subjectCandidates) {
                            if (loadProperty && !this._kb.hasPropertyValue(subject, property, object)) continue;
                            this.runNext(binding, arguments, subject, property, object);
                        }
                    }
                }
                break;
            }
            case SameAs: {
                ATermAppl saI1 = arguments.get(0);
                ATermAppl saI2 = arguments.get(1);
                for (ATermAppl known : this.getSymmetricCandidates(Query.VarType.INDIVIDUAL, saI1, saI2)) {
                    Set<ATermAppl> dependents = saI1.equals(saI2) ? Collections.singleton(known) : this._kb.getAllSames(known);
                    for (ATermAppl dependent : dependents) {
                        this.runSymetricCheck(current, saI1, known, saI2, dependent, binding);
                    }
                }
                break;
            }
            case DifferentFrom: {
                ATermAppl dfI1 = arguments.get(0);
                ATermAppl dfI2 = arguments.get(1);
                if (!dfI1.equals(dfI2)) {
                    for (ATermAppl known : this.getSymmetricCandidates(Query.VarType.INDIVIDUAL, dfI1, dfI2)) {
                        for (ATermAppl dependent : this._kb.getDifferents(known)) {
                            this.runSymetricCheck(current, dfI1, known, dfI2, dependent, binding);
                        }
                    }
                    break;
                }
                if (!_logger.isLoggable(Level.FINER)) break;
                _logger.finer("Atom " + current + "cannot be satisfied in any consistent ontology.");
                break;
            }
            case Annotation: {
                ATermAppl aI = arguments.get(0);
                ATermAppl aP = arguments.get(1);
                ATermAppl aIL = arguments.get(2);
                Set<ATermAppl> subjectCandidates = null;
                Object objectCandidates = null;
                Set<ATermAppl> propertyCandidates = null;
                subjectCandidates = ATermUtils.isVar(aI) ? this._kb.getAnnotationSubjects() : Collections.singleton(aI);
                propertyCandidates = ATermUtils.isVar(aP) ? this._kb.getAnnotationProperties() : Collections.singleton(aP);
                if (ATermUtils.isVar(aIL)) {
                    for (ATermAppl subject : subjectCandidates) {
                        for (ATermAppl property : propertyCandidates) {
                            for (ATermAppl object : this._kb.getAnnotations(subject, property)) {
                                this.runNext(binding, arguments, subject, property, object);
                            }
                        }
                    }
                } else {
                    for (ATermAppl subject : subjectCandidates) {
                        for (ATermAppl property : propertyCandidates) {
                            if (!this._kb.isAnnotation(subject, property, aIL)) continue;
                            this.runNext(binding, arguments, subject, property, aIL);
                        }
                    }
                }
                break;
            }
            case DirectSubClassOf: {
                direct = true;
            }
            case StrictSubClassOf: {
                strict = true;
            }
            case SubClassOf: {
                ATermAppl scLHS = arguments.get(0);
                ATermAppl scRHS = arguments.get(1);
                if (scLHS.equals(scRHS)) {
                    for (ATermAppl ic : this._kb.getClasses()) {
                        this.runNext(binding, arguments, ic, ic);
                    }
                } else {
                    Set<ATermAppl> lhsCandidates;
                    boolean lhsDM = this.isDownMonotonic(scLHS);
                    boolean rhsDM = this.isDownMonotonic(scRHS);
                    if (lhsDM || rhsDM) {
                        this.downMonotonic(this._kb.getTaxonomy(), this._kb.getClasses(), lhsDM, scLHS, scRHS, binding, direct, strict);
                        break;
                    }
                    Set<ATermAppl> rhsCandidates = null;
                    if (!ATermUtils.isVar(scLHS)) {
                        lhsCandidates = Collections.singleton(scLHS);
                        rhsCandidates = this.flatten(this._kb.getSuperClasses(scLHS, direct));
                        rhsCandidates.addAll(this._kb.getEquivalentClasses(scLHS));
                        if (strict) {
                            rhsCandidates.removeAll(this._kb.getEquivalentClasses(scLHS));
                        } else if (!ATermUtils.isComplexClass(scLHS)) {
                            rhsCandidates.add(scLHS);
                        }
                    } else if (!ATermUtils.isVar(scRHS)) {
                        rhsCandidates = Collections.singleton(scRHS);
                        if (scRHS.equals(ATermUtils.TOP)) {
                            lhsCandidates = new HashSet<ATermAppl>(this._kb.getAllClasses());
                        } else {
                            lhsCandidates = this.flatten(this._kb.getSubClasses(scRHS, direct));
                            lhsCandidates.addAll(this._kb.getAllEquivalentClasses(scRHS));
                        }
                        if (strict) {
                            lhsCandidates.removeAll(this._kb.getAllEquivalentClasses(scRHS));
                        }
                    } else {
                        lhsCandidates = this._kb.getClasses();
                    }
                    boolean reload = rhsCandidates == null;
                    for (ATermAppl subject : lhsCandidates) {
                        if (reload) {
                            rhsCandidates = this.flatten(this._kb.getSuperClasses(subject, direct));
                            if (strict) {
                                rhsCandidates.removeAll(this._kb.getEquivalentClasses(subject));
                            } else if (!ATermUtils.isComplexClass(subject)) {
                                rhsCandidates.add(subject);
                            }
                        }
                        if (rhsCandidates == null) continue;
                        for (ATermAppl object : rhsCandidates) {
                            this.runNext(binding, arguments, subject, object);
                        }
                    }
                }
                break;
            }
            case EquivalentClass: {
                ATermAppl eqcLHS = arguments.get(0);
                ATermAppl eqcRHS = arguments.get(1);
                block65: for (ATermAppl known : this.getSymmetricCandidates(Query.VarType.CLASS, eqcLHS, eqcRHS)) {
                    Set<ATermAppl> dependents = eqcLHS.equals(eqcRHS) ? Collections.singleton(known) : this._kb.getEquivalentClasses(known);
                    for (ATermAppl dependent : dependents) {
                        int size = this._result.size();
                        this.runSymetricCheck(current, eqcLHS, known, eqcRHS, dependent, binding);
                        if (this._result.size() != size) continue;
                        continue block65;
                    }
                }
                break;
            }
            case DisjointWith: {
                ATermAppl dwLHS = arguments.get(0);
                ATermAppl dwRHS = arguments.get(1);
                if (!dwLHS.equals(dwRHS)) {
                    for (ATermAppl known : this.getSymmetricCandidates(Query.VarType.CLASS, dwLHS, dwRHS)) {
                        for (Set<ATermAppl> dependents : this._kb.getDisjointClasses(known)) {
                            for (ATermAppl dependent : dependents) {
                                this.runSymetricCheck(current, dwLHS, known, dwRHS, dependent, binding);
                            }
                        }
                    }
                    break;
                }
                _logger.finer("Atom " + current + "cannot be satisfied in any consistent ontology.");
                break;
            }
            case ComplementOf: {
                ATermAppl coLHS = arguments.get(0);
                ATermAppl coRHS = arguments.get(1);
                if (!coLHS.equals(coRHS)) {
                    for (ATermAppl known : this.getSymmetricCandidates(Query.VarType.CLASS, coLHS, coRHS)) {
                        for (ATermAppl dependent : this._kb.getComplements(known)) {
                            this.runSymetricCheck(current, coLHS, known, coRHS, dependent, binding);
                        }
                    }
                    break;
                }
                _logger.finer("Atom " + current + "cannot be satisfied in any consistent ontology.");
                break;
            }
            case DirectSubPropertyOf: {
                direct = true;
            }
            case StrictSubPropertyOf: {
                strict = true;
            }
            case SubPropertyOf: {
                ATermAppl spLHS = arguments.get(0);
                ATermAppl spRHS = arguments.get(1);
                if (spLHS.equals(spRHS)) {
                    for (ATermAppl ic : this._kb.getProperties()) {
                        this.runNext(binding, arguments, ic, ic);
                    }
                } else {
                    Set<ATermAppl> spLhsCandidates;
                    boolean lhsDM = this.isDownMonotonic(spLHS);
                    boolean rhsDM = this.isDownMonotonic(spRHS);
                    if (lhsDM || rhsDM) {
                        this.downMonotonic(this._kb.getRoleTaxonomy(true), this._kb.getProperties(), lhsDM, spLHS, spRHS, binding, direct, strict);
                        break;
                    }
                    Set<ATermAppl> spRhsCandidates = null;
                    if (!ATermUtils.isVar(spLHS)) {
                        spLhsCandidates = Collections.singleton(spLHS);
                        spRhsCandidates = this.flatten(this._kb.getSuperProperties(spLHS, direct));
                        if (strict) {
                            spRhsCandidates.removeAll(this._kb.getEquivalentProperties(spLHS));
                        } else {
                            spRhsCandidates.add(spLHS);
                        }
                    } else if (!ATermUtils.isVar(spRHS)) {
                        spRhsCandidates = Collections.singleton(spRHS);
                        spLhsCandidates = this.flatten(this._kb.getSubProperties(spRHS, direct));
                        if (strict) {
                            spLhsCandidates.removeAll(this._kb.getEquivalentProperties(spRHS));
                        } else {
                            spLhsCandidates.add(spRHS);
                        }
                    } else {
                        spLhsCandidates = this._kb.getProperties();
                    }
                    boolean reload = spRhsCandidates == null;
                    for (ATermAppl subject : spLhsCandidates) {
                        if (reload) {
                            spRhsCandidates = this.flatten(this._kb.getSuperProperties(subject, direct));
                            if (strict) {
                                spRhsCandidates.removeAll(this._kb.getEquivalentProperties(subject));
                            } else {
                                spRhsCandidates.add(subject);
                            }
                        }
                        if (spRhsCandidates == null) continue;
                        for (ATermAppl object : spRhsCandidates) {
                            this.runNext(binding, arguments, subject, object);
                        }
                    }
                }
                break;
            }
            case EquivalentProperty: {
                ATermAppl eqpLHS = arguments.get(0);
                ATermAppl eqpRHS = arguments.get(1);
                block75: for (ATermAppl known : this.getSymmetricCandidates(Query.VarType.PROPERTY, eqpLHS, eqpRHS)) {
                    Set<ATermAppl> dependents = eqpLHS.equals(eqpRHS) ? Collections.singleton(known) : this._kb.getEquivalentProperties(known);
                    for (ATermAppl dependent : dependents) {
                        int size = this._result.size();
                        this.runSymetricCheck(current, eqpLHS, known, eqpRHS, dependent, binding);
                        if (this._result.size() != size) continue;
                        continue block75;
                    }
                }
                break;
            }
            case Domain: {
                ATermAppl domLHS = arguments.get(0);
                ATermAppl domRHS = arguments.get(1);
                Set<ATermAppl> domLhsCandidates = !ATermUtils.isVar(domLHS) ? Collections.singleton(domLHS) : this._kb.getProperties();
                Set<ATermAppl> domRhsCandidates = !ATermUtils.isVar(domRHS) ? Collections.singleton(domRHS) : this._kb.getAllClasses();
                for (ATermAppl prop : domLhsCandidates) {
                    for (ATermAppl cls : domRhsCandidates) {
                        if (!this._kb.isDatatypeProperty(prop) && !this._kb.isObjectProperty(prop) || !this._kb.hasDomain(prop, cls)) continue;
                        this.runNext(binding, arguments, prop, cls);
                    }
                }
                break;
            }
            case Range: {
                Set<Object> rangeRhsDTypeCandidates;
                Set<ATermAppl> rangeRhsClassCandidates;
                ATermAppl rangeLHS = arguments.get(0);
                ATermAppl rangeRHS = arguments.get(1);
                Set<ATermAppl> rangeLhsCandidates = !ATermUtils.isVar(rangeLHS) ? Collections.singleton(rangeLHS) : this._kb.getProperties();
                if (!ATermUtils.isVar(rangeRHS)) {
                    if (this._kb.isDatatype(rangeRHS)) {
                        rangeRhsClassCandidates = Collections.emptySet();
                        rangeRhsDTypeCandidates = Collections.singleton(rangeRHS);
                    } else {
                        rangeRhsClassCandidates = Collections.singleton(rangeRHS);
                        rangeRhsDTypeCandidates = Collections.emptySet();
                    }
                } else {
                    rangeRhsClassCandidates = this._kb.getAllClasses();
                    rangeRhsDTypeCandidates = new HashSet();
                    for (ATermAppl dtype : this._kb.getDatatypeReasoner().listDataRanges()) {
                        rangeRhsDTypeCandidates.add(dtype);
                    }
                }
                for (ATermAppl prop : rangeLhsCandidates) {
                    if (this._kb.isObjectProperty(prop)) {
                        for (ATermAppl aTermAppl : rangeRhsClassCandidates) {
                            if (!this._kb.hasRange(prop, aTermAppl)) continue;
                            this.runNext(binding, arguments, prop, aTermAppl);
                        }
                        continue;
                    }
                    if (!this._kb.isDatatypeProperty(prop)) continue;
                    for (ATermAppl aTermAppl : rangeRhsDTypeCandidates) {
                        if (!this._kb.hasRange(prop, aTermAppl)) continue;
                        this.runNext(binding, arguments, prop, aTermAppl);
                    }
                }
                break;
            }
            case InverseOf: {
                ATermAppl ioLHS = arguments.get(0);
                ATermAppl ioRHS = arguments.get(1);
                if (ioLHS.equals(ioRHS)) {
                    this.runAllPropertyChecks(current, arguments.get(0), this._kb.getSymmetricProperties(), binding);
                    break;
                }
                for (ATermAppl aTermAppl : this.getSymmetricCandidates(Query.VarType.PROPERTY, ioLHS, ioRHS)) {
                    for (ATermAppl dependent : this._kb.getInverses(aTermAppl)) {
                        this.runSymetricCheck(current, ioLHS, aTermAppl, ioRHS, dependent, binding);
                    }
                }
                break;
            }
            case Symmetric: {
                this.runAllPropertyChecks(current, arguments.get(0), this._kb.getSymmetricProperties(), binding);
                break;
            }
            case Asymmetric: {
                this.runAllPropertyChecks(current, arguments.get(0), this._kb.getAsymmetricProperties(), binding);
                break;
            }
            case Reflexive: {
                this.runAllPropertyChecks(current, arguments.get(0), this._kb.getReflexiveProperties(), binding);
                break;
            }
            case Irreflexive: {
                this.runAllPropertyChecks(current, arguments.get(0), this._kb.getIrreflexiveProperties(), binding);
                break;
            }
            case ObjectProperty: {
                this.runAllPropertyChecks(current, arguments.get(0), this._kb.getObjectProperties(), binding);
                break;
            }
            case DatatypeProperty: {
                this.runAllPropertyChecks(current, arguments.get(0), this._kb.getDataProperties(), binding);
                break;
            }
            case Functional: {
                this.runAllPropertyChecks(current, arguments.get(0), this._kb.getFunctionalProperties(), binding);
                break;
            }
            case InverseFunctional: {
                this.runAllPropertyChecks(current, arguments.get(0), this._kb.getInverseFunctionalProperties(), binding);
                break;
            }
            case Transitive: {
                this.runAllPropertyChecks(current, arguments.get(0), this._kb.getTransitiveProperties(), binding);
                break;
            }
            case UndistVarCore: {
                CoreNewImpl core = (CoreNewImpl)current.apply(binding);
                Collection collection = core.getDistVars();
                if (collection.isEmpty()) {
                    ATermAppl clazz;
                    Collection constants = core.getConstants();
                    if (constants.isEmpty()) {
                        if (!QueryEngine.execBooleanABoxQuery(core.getQuery())) break;
                        this._result.add(binding);
                        break;
                    }
                    ATermAppl c = (ATermAppl)constants.iterator().next();
                    if (!this._kb.isType(c, clazz = core.getQuery().rollUpTo(c, Collections.emptySet(), false))) break;
                    this.exec(binding);
                    break;
                }
                if (collection.size() == 1) {
                    ATermAppl var = (ATermAppl)collection.iterator().next();
                    ATermAppl c = core.getQuery().rollUpTo(var, Collections.emptySet(), false);
                    Set<ATermAppl> instances = this._kb.getInstances(c);
                    for (ATermAppl a : instances) {
                        ResultBinding candidateBinding = binding.duplicate();
                        candidateBinding.setValue(var, a);
                        this.exec(candidateBinding);
                    }
                    break;
                }
                CoreStrategy s = QueryEngine.getStrategy(current);
                switch (s) {
                    case SIMPLE: {
                        this.execSimpleCore(this._oldQuery, binding, collection);
                        break block0;
                    }
                    case ALLFAST: {
                        this.execAllFastCore(this._oldQuery, binding, collection, core.getUndistVars());
                        break block0;
                    }
                }
                throw new InternalReasonerException("Unknown core _strategy.");
            }
            case NegativePropertyValue: {
                ATermAppl s = arguments.get(0);
                ATermAppl p = arguments.get(1);
                ATermAppl o = arguments.get(2);
                if (ATermUtils.isVar(p)) {
                    throw new UnsupportedQueryException("NegativePropertyValue atom with a variable property not supported");
                }
                if (ATermUtils.isVar(o) && this._kb.isDatatypeProperty(p)) {
                    throw new UnsupportedQueryException("NegativePropertyValue atom with a datatype property and variable object not supported");
                }
                if (ATermUtils.isVar(s)) {
                    Set<ATermAppl> oValues = ATermUtils.isVar(o) ? this._kb.getIndividuals() : Collections.singleton(o);
                    for (ATermAppl oValue : oValues) {
                        Set<ATermAppl> sValues = this._kb.getInstances(TermFactory.not(TermFactory.hasValue(p, oValue)));
                        for (ATermAppl sValue : sValues) {
                            this.runNext(binding, arguments, sValue, p, oValue);
                        }
                    }
                    break;
                }
                if (ATermUtils.isVar(o)) {
                    Set<ATermAppl> oValues = this._kb.getInstances(TermFactory.not(TermFactory.hasValue(TermFactory.inv(p), o)));
                    for (ATermAppl oValue : oValues) {
                        this.runNext(binding, arguments, s, p, oValue);
                    }
                    break;
                }
                if (!this._kb.isType(s, TermFactory.hasValue(p, o))) break;
                this.exec(binding);
                break;
            }
            case NotKnown: {
                QueryImpl newQuery = new QueryImpl(this._kb, true);
                for (QueryAtom atom : ((NotKnownQueryAtom)current).getAtoms()) {
                    newQuery.add(atom.apply(binding));
                }
                for (ATermAppl var : newQuery.getUndistVars()) {
                    newQuery.addDistVar(var, Query.VarType.INDIVIDUAL);
                }
                CombinedQueryEngine newEngine = new CombinedQueryEngine();
                boolean isNegationTrue = newEngine.exec(newQuery).isEmpty();
                if (!isNegationTrue) break;
                this.exec(binding);
                break;
            }
            case Union: {
                for (List<QueryAtom> atoms : ((UnionQueryAtom)current).getUnion()) {
                    QueryImpl newQuery = new QueryImpl(this._kb, true);
                    for (QueryAtom atom : atoms) {
                        newQuery.add(atom.apply(binding));
                    }
                    for (ATermAppl var : newQuery.getUndistVars()) {
                        newQuery.addDistVar(var, Query.VarType.INDIVIDUAL);
                        newQuery.addResultVar(var);
                    }
                    CombinedQueryEngine newEngine = new CombinedQueryEngine();
                    QueryResult newResult = newEngine.exec(newQuery);
                    for (ResultBinding newBinding : newResult) {
                        newBinding.setValues(binding);
                        this.exec(newBinding);
                    }
                }
                break;
            }
            case Datatype: {
                throw new UnsupportedQueryException("Datatype atom not ground: " + current);
            }
            case propertyDisjointWith: {
                ATermAppl dwLHSp = arguments.get(0);
                ATermAppl dwRHSp = arguments.get(1);
                if (!dwLHSp.equals(dwRHSp)) {
                    for (ATermAppl known : this.getSymmetricCandidates(Query.VarType.PROPERTY, dwLHSp, dwRHSp)) {
                        for (Set<ATermAppl> dependents : this._kb.getDisjointProperties(known)) {
                            for (ATermAppl dependent : dependents) {
                                this.runSymetricCheck(current, dwLHSp, known, dwRHSp, dependent, binding);
                            }
                        }
                    }
                    break;
                }
                _logger.finer("Atom " + current + "cannot be satisfied in any consistent ontology.");
                break;
            }
            default: {
                throw new UnsupportedQueryException("Unknown atom type '" + (Object)((Object)current.getPredicate()) + "'.");
            }
        }
    }

    private void execSimpleCore(Query q, ResultBinding binding, Collection<ATermAppl> distVars) {
        HashMap<ATermAppl, Set<ATermAppl>> varBindings = new HashMap<ATermAppl, Set<ATermAppl>>();
        KnowledgeBase kb = q.getKB();
        for (ATermAppl currVar : distVars) {
            ATermAppl rolledUpClass = q.rollUpTo(currVar, Collections.emptySet(), false);
            if (_logger.isLoggable(Level.FINER)) {
                _logger.finer(currVar + " rolled to " + rolledUpClass);
            }
            Set<ATermAppl> inst = kb.getInstances(rolledUpClass);
            varBindings.put(currVar, inst);
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.finer("Var bindings: " + varBindings);
        }
        Set<ATermAppl> literalVars = q.getDistVarsForType(Query.VarType.LITERAL);
        Set<ATermAppl> individualVars = q.getDistVarsForType(Query.VarType.INDIVIDUAL);
        boolean hasLiterals = !individualVars.containsAll(literalVars);
        BindingIterator i = new BindingIterator(varBindings);
        while (i.hasNext()) {
            ResultBinding candidate = ((ResultBinding)i.next()).duplicate();
            candidate.setValues(binding);
            if (hasLiterals) {
                LiteralIterator l = new LiteralIterator(q, candidate);
                while (l.hasNext()) {
                    ResultBinding mappy = binding.duplicate();
                    mappy.setValues((ResultBinding)l.next());
                    if (!QueryEngine.execBooleanABoxQuery(q.apply(mappy))) continue;
                    this.exec(mappy);
                }
                continue;
            }
            if (!QueryEngine.execBooleanABoxQuery(q.apply(candidate))) continue;
            this.exec(candidate);
        }
    }

    private Map<ATermAppl, Boolean> fastPrune(Query q, ATermAppl var) {
        ATermAppl c = q.rollUpTo(var, Collections.emptySet(), false);
        if (_logger.isLoggable(Level.FINER)) {
            _logger.finer(var + " rolled to " + c);
        }
        CandidateSet<ATermAppl> set = this._kb.getABox().getObviousInstances(c);
        HashMap<ATermAppl, Boolean> map = new HashMap<ATermAppl, Boolean>();
        for (ATermAppl o : set.getKnowns()) {
            map.put(o, true);
        }
        for (ATermAppl o : set.getUnknowns()) {
            map.put(o, false);
        }
        return map;
    }

    private void execAllFastCore(Query q, ResultBinding binding, Collection<ATermAppl> distVars, Collection<ATermAppl> undistVars) {
        if (distVars.isEmpty()) {
            this.exec(binding);
        } else {
            ATermAppl var = distVars.iterator().next();
            distVars.remove(var);
            Map<ATermAppl, Boolean> instances = this.fastPrune(q, var);
            for (Map.Entry<ATermAppl, Boolean> entry : instances.entrySet()) {
                ATermAppl b = entry.getKey();
                ResultBinding newBinding = binding.duplicate();
                newBinding.setValue(var, b);
                Query q2 = q.apply(newBinding);
                if (!entry.getValue().booleanValue() && !QueryEngine.execBooleanABoxQuery(q2)) continue;
                this.execAllFastCore(q2, newBinding, distVars, undistVars);
            }
            distVars.add(var);
        }
    }

    private void downMonotonic(Taxonomy<ATermAppl> taxonomy, Collection<ATermAppl> all, boolean lhsDM, ATermAppl lhs, ATermAppl rhs, ResultBinding binding, boolean direct, boolean strict) {
        Collection<ATermAppl> candidates;
        ATermAppl theOther;
        ATermAppl downMonotonic = lhsDM ? lhs : rhs;
        ATermAppl aTermAppl = theOther = lhsDM ? rhs : lhs;
        if (ATermUtils.isVar(theOther)) {
            candidates = all;
        } else {
            ATermAppl top;
            ATermAppl aTermAppl2 = top = lhsDM ? rhs : taxonomy.getTop().getName();
            if (ATermUtils.isComplexClass(top)) {
                candidates = this._kb.getEquivalentClasses(top);
                if (!strict && candidates.isEmpty()) {
                    candidates = this.flatten(this._kb.getSubClasses(top, true));
                }
            } else {
                candidates = Collections.singleton(top);
            }
        }
        for (ATermAppl candidate : candidates) {
            Set<ATermAppl> toDo;
            ResultBinding newBinding = binding.duplicate();
            if (ATermUtils.isVar(theOther)) {
                newBinding.setValue(theOther, candidate);
            }
            Set<ATermAppl> set = toDo = lhsDM ? this.flatten(taxonomy.getSubs(candidate, direct)) : this.flatten(taxonomy.getSupers(candidate, direct));
            if (strict) {
                toDo.removeAll(taxonomy.getEquivalents(candidate));
            } else {
                toDo.add(candidate);
            }
            this.runRecursively(taxonomy, downMonotonic, candidate, newBinding, new HashSet<ATermAppl>(toDo), direct, strict);
        }
    }

    private boolean isDownMonotonic(ATermAppl scLHS) {
        return OpenlletOptions.OPTIMIZE_DOWN_MONOTONIC && this._downMonotonic.contains(scLHS);
    }

    private void runNext(ResultBinding binding, List<ATermAppl> arguments, ATermAppl ... values) {
        ResultBinding candidateBinding = binding.duplicate();
        for (int i = 0; i < arguments.size(); ++i) {
            if (!ATermUtils.isVar(arguments.get(i))) continue;
            candidateBinding.setValue(arguments.get(i), values[i]);
        }
        this.exec(candidateBinding);
    }

    private Set<ATermAppl> getSymmetricCandidates(Query.VarType forType, ATermAppl cA, ATermAppl cB) {
        Set<ATermAppl> candidates;
        if (!ATermUtils.isVar(cA)) {
            candidates = Collections.singleton(cA);
        } else if (!ATermUtils.isVar(cB)) {
            candidates = Collections.singleton(cB);
        } else {
            switch (forType) {
                case CLASS: {
                    candidates = this._kb.getClasses();
                    break;
                }
                case PROPERTY: {
                    candidates = this._kb.getProperties();
                    break;
                }
                case INDIVIDUAL: {
                    candidates = this._kb.getIndividuals();
                    break;
                }
                default: {
                    throw new OpenError("Uknown variable type : " + (Object)((Object)forType));
                }
            }
        }
        return candidates;
    }

    private void runRecursively(Taxonomy<ATermAppl> t, ATermAppl downMonotonic, ATermAppl rootCandidate, ResultBinding binding, Set<ATermAppl> toDo, boolean direct, boolean strict) {
        int size = this._result.size();
        _logger.fine(() -> "Trying : " + rootCandidate + ", done=" + toDo);
        if (!strict) {
            toDo.remove(rootCandidate);
            this.runNext(binding, Collections.singletonList(downMonotonic), rootCandidate);
        }
        if (strict || this._result.size() > size) {
            Set<ATermAppl> subs = this.flatten(t.getSubs(rootCandidate, direct));
            for (ATermAppl subject : subs) {
                if (!toDo.contains(subject)) continue;
                this.runRecursively(t, downMonotonic, subject, binding, toDo, false, false);
            }
        } else {
            _logger.fine(() -> "Skipping subs of " + rootCandidate);
            toDo.removeAll(this.flatten(t.getSubs(rootCandidate, false)));
        }
    }

    private void runSymetricCheck(QueryAtom current, ATermAppl cA, ATermAppl known, ATermAppl cB, ATermAppl dependent, ResultBinding binding) {
        ResultBinding candidateBinding = binding.duplicate();
        if (!ATermUtils.isVar(cA)) {
            candidateBinding.setValue(cB, dependent);
        } else if (!ATermUtils.isVar(cB)) {
            candidateBinding.setValue(cA, dependent);
        } else {
            candidateBinding.setValue(cA, known);
            candidateBinding.setValue(cB, dependent);
        }
        this.exec(candidateBinding);
    }

    private void runAllPropertyChecks(QueryAtom current, ATermAppl var, Set<ATermAppl> candidates, ResultBinding binding) {
        if (this.isDownMonotonic(var)) {
            for (TaxonomyNode<ATermAppl> topNode : this._kb.getRoleTaxonomy(true).getTop().getSubs()) {
                ATermAppl top = topNode.getName();
                if (!candidates.contains(top)) continue;
                this.runRecursively(this._kb.getRoleTaxonomy(true), var, topNode.getName(), binding, new HashSet<ATermAppl>(candidates), false, false);
            }
        } else {
            for (ATermAppl candidate : candidates) {
                ResultBinding candidateBinding = binding.duplicate();
                candidateBinding.setValue(var, candidate);
                this.exec(candidateBinding);
            }
        }
    }

    private Set<ATermAppl> flatten(Set<Set<ATermAppl>> set) {
        HashSet<ATermAppl> result = new HashSet<ATermAppl>();
        for (Set<ATermAppl> set2 : set) {
            for (ATermAppl a : set2) {
                result.add(a);
            }
        }
        return result;
    }
}

