/*
 * Decompiled with CFR 0.152.
 */
package openllet.query.sparqldl.engine;

import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import openllet.core.exceptions.InternalReasonerException;
import openllet.core.utils.SetUtils;
import openllet.query.sparqldl.engine.QueryCost;
import openllet.query.sparqldl.engine.QueryPlan;
import openllet.query.sparqldl.engine.QuerySizeEstimator;
import openllet.query.sparqldl.model.Query;
import openllet.query.sparqldl.model.QueryAtom;
import openllet.query.sparqldl.model.QueryPredicate;
import openllet.query.sparqldl.model.ResultBinding;
import openllet.shared.tools.Log;

public class IncrementalQueryPlan
extends QueryPlan {
    private static final Logger _logger = Log.getLogger(IncrementalQueryPlan.class);
    public final Stack<Integer> _explored;
    private final List<QueryAtom> _atoms;
    private final int _size;
    private final QueryCost _cost;

    public IncrementalQueryPlan(Query query2) {
        super(query2);
        QuerySizeEstimator.computeSizeEstimate(query2);
        this._explored = new Stack();
        this._atoms = query2.getAtoms();
        this._size = this._atoms.size();
        this._cost = new QueryCost(query2.getKB());
        this.reset();
    }

    @Override
    public QueryAtom next(ResultBinding binding) {
        int best = -1;
        QueryAtom bestAtom = null;
        double bestCost = Double.POSITIVE_INFINITY;
        block0: for (int i = 0; i < this._size; ++i) {
            if (this._explored.contains(i)) continue;
            QueryAtom atom = this._atoms.get(i);
            QueryAtom atom2 = atom.apply(binding);
            if (atom2.getPredicate().equals((Object)QueryPredicate.NotKnown) && !atom2.isGround()) {
                for (int j = 0; j < this._atoms.size(); ++j) {
                    QueryAtom nextAtom;
                    if (i == j || this._explored.contains(j) || !SetUtils.intersects((nextAtom = this._atoms.get(j)).getArguments(), atom2.getArguments())) continue;
                    if (!_logger.isLoggable(Level.FINE)) continue block0;
                    _logger.fine("Unbound vars for not");
                    continue block0;
                }
            }
            double atomCost = this._cost.estimate(atom2);
            if (_logger.isLoggable(Level.FINER)) {
                _logger.finer("Atom=" + atom + ", _cost=" + this._cost + ", best _cost=" + bestCost);
            }
            if (!(atomCost <= bestCost)) continue;
            bestCost = atomCost;
            bestAtom = atom2;
            best = i;
        }
        if (best == -1) {
            throw new InternalReasonerException("Cannot find a valid atom in " + this._atoms + " where _explored=" + this._explored);
        }
        this._explored.add(best);
        if (_logger.isLoggable(Level.FINER)) {
            StringBuffer indent = new StringBuffer();
            for (int j = 0; j < this._explored.size(); ++j) {
                indent.append(" ");
            }
            String treePrint = indent.toString() + bestAtom + " : " + bestCost;
            _logger.finer(treePrint);
        }
        return bestAtom;
    }

    @Override
    public boolean hasNext() {
        return this._explored.size() < this._size;
    }

    @Override
    public void back() {
        this._explored.pop();
    }

    @Override
    public void reset() {
        this._explored.clear();
    }
}

