/*
 * Decompiled with CFR 0.152.
 */
package openllet.query.sparqldl.jena;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import openllet.core.KnowledgeBase;
import openllet.core.OpenlletOptions;
import openllet.core.exceptions.UnsupportedQueryException;
import openllet.jena.PelletInfGraph;
import openllet.query.sparqldl.engine.QueryEngine;
import openllet.query.sparqldl.jena.SlicedResultSet;
import openllet.query.sparqldl.jena.SortedResultSet;
import openllet.query.sparqldl.jena.SparqlDLResultSet;
import openllet.query.sparqldl.model.Query;
import openllet.query.sparqldl.model.QueryParameters;
import openllet.query.sparqldl.model.QueryParametersBuilder;
import openllet.query.sparqldl.parser.ARQParser;
import openllet.shared.tools.Log;
import org.apache.jena.atlas.json.JsonArray;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.atlas.lib.NotImplemented;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.QueryException;
import org.apache.jena.query.QueryExecException;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.SortCondition;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.syntax.Template;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.ModelUtils;

class SparqlDLExecution
implements QueryExecution {
    public static Logger _logger = Log.getLogger(SparqlDLExecution.class);
    private final org.apache.jena.query.Query _query;
    private final Dataset _source;
    private QuerySolution _initialBinding;
    private boolean _purePelletQueryExec = false;
    private boolean _handleVariableSPO = true;

    public SparqlDLExecution(String query2, Model source) {
        this(QueryFactory.create(query2), source);
    }

    public SparqlDLExecution(org.apache.jena.query.Query query2, Model source) {
        this(query2, DatasetFactory.create(source));
    }

    public SparqlDLExecution(org.apache.jena.query.Query query2, Dataset source) {
        this(query2, source, true);
    }

    public SparqlDLExecution(org.apache.jena.query.Query query2, Dataset source, boolean handleVariableSPO) {
        this._query = query2;
        this._source = source;
        this._handleVariableSPO = handleVariableSPO;
        Graph graph = source.getDefaultModel().getGraph();
        if (!(graph instanceof PelletInfGraph)) {
            throw new QueryException("PelletQueryExecution can only be used with Pellet-backed models");
        }
        if (OpenlletOptions.FULL_SIZE_ESTIMATE) {
            ((PelletInfGraph)graph).getKB().getSizeEstimate().computeAll();
        }
    }

    @Override
    public Model execDescribe() {
        throw new UnsupportedOperationException("Not supported yet!");
    }

    @Override
    public Model execDescribe(Model model) {
        throw new UnsupportedOperationException("Not supported yet!");
    }

    @Override
    public Model execConstruct() {
        Model model = ModelFactory.createDefaultModel();
        this.execConstruct(model);
        return model;
    }

    @Override
    public Model execConstruct(Model model) {
        this.ensureQueryType(QueryType.CONSTRUCT);
        ResultSet results = this.exec();
        if (results == null) {
            QueryExecutionFactory.create(this._query, this._source, this._initialBinding).execConstruct(model);
        } else {
            model.setNsPrefixes(this._source.getDefaultModel());
            model.setNsPrefixes(this._query.getPrefixMapping());
            HashSet<Triple> set = new HashSet<Triple>();
            Template template = this._query.getConstructTemplate();
            while (results.hasNext()) {
                HashMap<Node, Node> bNodeMap = new HashMap<Node, Node>();
                Binding binding = results.nextBinding();
                template.subst(set, bNodeMap, binding);
            }
            for (Triple t : set) {
                Statement stmt = ModelUtils.tripleToStatement(model, t);
                if (stmt == null) continue;
                model.add(stmt);
            }
            this.close();
        }
        return model;
    }

    @Override
    public boolean execAsk() {
        this.ensureQueryType(QueryType.ASK);
        ResultSet results = this.exec();
        return results != null ? results.hasNext() : QueryExecutionFactory.create(this._query, this._source, this._initialBinding).execAsk();
    }

    @Override
    public ResultSet execSelect() {
        this.ensureQueryType(QueryType.SELECT);
        ResultSet results = this.exec();
        return results != null ? results : QueryExecutionFactory.create(this._query, this._source, this._initialBinding).execSelect();
    }

    private ResultSet exec() {
        try {
            if (this._source.listNames().hasNext()) {
                throw new UnsupportedQueryException("Named graphs is not supported by Pellet");
            }
            PelletInfGraph pelletInfGraph = (PelletInfGraph)this._source.getDefaultModel().getGraph();
            KnowledgeBase kb = pelletInfGraph.getKB();
            pelletInfGraph.prepare();
            QueryParameters queryParameters = QueryParametersBuilder.getQueryParameters(this._initialBinding);
            ARQParser parser = new ARQParser(this._handleVariableSPO);
            parser.setInitialBinding(this._initialBinding);
            Query q = parser.parse(this._query, kb);
            q.setQueryParameters(queryParameters);
            ResultSet results = new SparqlDLResultSet(QueryEngine.exec(q), this._source.getDefaultModel(), queryParameters);
            List<SortCondition> sortConditions = this._query.getOrderBy();
            if (sortConditions != null && !sortConditions.isEmpty()) {
                results = new SortedResultSet(results, sortConditions);
            }
            if (this._query.hasOffset() || this._query.hasLimit()) {
                long offset = this._query.hasOffset() ? this._query.getOffset() : 0L;
                long limit = this._query.hasLimit() ? this._query.getLimit() : Long.MAX_VALUE;
                results = new SlicedResultSet(results, offset, limit);
            }
            return results;
        }
        catch (UnsupportedQueryException e2) {
            _logger.log(this._purePelletQueryExec ? Level.INFO : Level.FINE, "This is not a SPARQL-DL _query: " + e2.getMessage());
            if (this._purePelletQueryExec) {
                throw e2;
            }
            _logger.fine("Falling back to Jena _query engine");
            return null;
        }
    }

    @Override
    public void abort() {
        throw new UnsupportedOperationException("Not supported yet!");
    }

    @Override
    public void close() {
        _logger.fine("Closing PelletQueryExecution '" + this.hashCode() + "'.");
    }

    @Override
    public void setInitialBinding(QuerySolution startSolution) {
        this._initialBinding = startSolution;
    }

    @Override
    public Context getContext() {
        throw new UnsupportedOperationException("Not supported yet!");
    }

    @Override
    public Dataset getDataset() {
        return this._source;
    }

    private void ensureQueryType(QueryType expectedType) throws QueryExecException {
        QueryType actualType = SparqlDLExecution.getQueryType(this._query);
        if (actualType != expectedType) {
            throw new QueryExecException("Attempt to execute a " + (Object)((Object)actualType) + " _query as a " + (Object)((Object)expectedType) + " _query");
        }
    }

    private static QueryType getQueryType(org.apache.jena.query.Query query2) {
        if (query2.isSelectType()) {
            return QueryType.SELECT;
        }
        if (query2.isConstructType()) {
            return QueryType.CONSTRUCT;
        }
        if (query2.isDescribeType()) {
            return QueryType.DESCRIBE;
        }
        if (query2.isAskType()) {
            return QueryType.ASK;
        }
        return null;
    }

    public boolean isPurePelletQueryExec() {
        return this._purePelletQueryExec;
    }

    public void setPurePelletQueryExec(boolean purePelletQueryExec) {
        this._purePelletQueryExec = purePelletQueryExec;
    }

    @Override
    public Iterator<Triple> execConstructTriples() {
        return ModelUtils.statementsToTriples(this.execConstruct().listStatements());
    }

    @Override
    public Iterator<Quad> execConstructQuads() {
        throw new NotImplemented();
    }

    @Override
    public Dataset execConstructDataset() {
        throw new NotImplemented();
    }

    @Override
    public Dataset execConstructDataset(Dataset dataset) {
        throw new NotImplemented();
    }

    @Override
    public Iterator<Triple> execDescribeTriples() {
        return ModelUtils.statementsToTriples(this.execDescribe().listStatements());
    }

    @Override
    public org.apache.jena.query.Query getQuery() {
        return this._query;
    }

    @Override
    public long getTimeout1() {
        return -1L;
    }

    @Override
    public long getTimeout2() {
        return -1L;
    }

    @Override
    public void setTimeout(long arg0) {
    }

    @Override
    public void setTimeout(long arg0, TimeUnit arg1) {
    }

    @Override
    public void setTimeout(long arg0, long arg1) {
    }

    @Override
    public void setTimeout(long arg0, TimeUnit arg1, long arg2, TimeUnit arg3) {
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public JsonArray execJson() {
        throw new NotImplemented();
    }

    @Override
    public Iterator<JsonObject> execJsonItems() {
        throw new NotImplemented();
    }

    private static enum QueryType {
        ASK,
        CONSTRUCT,
        DESCRIBE,
        SELECT;

    }
}

