/*
 * Decompiled with CFR 0.152.
 */
package openllet.query.sparqldl.jena;

import java.util.logging.Level;
import java.util.logging.Logger;
import openllet.core.KnowledgeBase;
import openllet.core.exceptions.UnsupportedQueryException;
import openllet.jena.PelletInfGraph;
import openllet.query.sparqldl.jena.SparqlDLExecution;
import openllet.query.sparqldl.jena.SparqlDLStageGenerator;
import openllet.query.sparqldl.parser.ARQParser;
import openllet.shared.tools.Log;
import org.apache.jena.graph.Graph;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryException;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.rdf.model.Model;

public class SparqlDLExecutionFactory {
    private static final Logger _logger = Log.getLogger(SparqlDLExecutionFactory.class);

    public static QueryExecution create(Query query2, Dataset dataset, QuerySolution initialBinding) {
        QueryEngineType engineType = QueryEngineType.ARQ;
        Graph graph = dataset.getDefaultModel().getGraph();
        if (graph instanceof PelletInfGraph) {
            if (dataset.listNames().hasNext() || query2.isDescribeType()) {
                engineType = QueryEngineType.MIXED;
            } else {
                PelletInfGraph pelletInfGraph = (PelletInfGraph)graph;
                KnowledgeBase kb = pelletInfGraph.getKB();
                pelletInfGraph.prepare();
                ARQParser parser = new ARQParser();
                parser.setInitialBinding(initialBinding);
                try {
                    parser.parse(query2, kb);
                    engineType = QueryEngineType.PELLET;
                }
                catch (UnsupportedQueryException e2) {
                    _logger.log(Level.FINER, "", e2);
                    engineType = QueryEngineType.MIXED;
                }
            }
        }
        return SparqlDLExecutionFactory.create(query2, dataset, initialBinding, engineType);
    }

    public static QueryExecution create(Query query2, Dataset dataset, QuerySolution initialBinding, QueryEngineType queryEngineType) {
        return SparqlDLExecutionFactory.create(query2, dataset, initialBinding, queryEngineType, true);
    }

    public static QueryExecution create(Query query2, Dataset dataset, QuerySolution initialBinding, QueryEngineType queryEngineType, boolean handleVariableSPO) throws QueryException {
        QueryExecution queryExec = null;
        switch (queryEngineType) {
            case PELLET: {
                queryExec = new SparqlDLExecution(query2, dataset, handleVariableSPO);
                ((SparqlDLExecution)queryExec).setPurePelletQueryExec(true);
                break;
            }
            case ARQ: {
                queryExec = QueryExecutionFactory.create(query2, dataset);
                break;
            }
            case MIXED: {
                queryExec = QueryExecutionFactory.create(query2, dataset);
                queryExec.getContext().set(ARQ.stageGenerator, new SparqlDLStageGenerator(handleVariableSPO));
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (initialBinding != null) {
            queryExec.setInitialBinding(initialBinding);
        }
        return queryExec;
    }

    public static QueryExecution create(Query query2, Model model) {
        return SparqlDLExecutionFactory.create(query2, model, null);
    }

    public static QueryExecution create(Query query2, Dataset dataset) {
        return SparqlDLExecutionFactory.create(query2, dataset, null);
    }

    public static QueryExecution create(Query query2, Model model, QuerySolution initialBinding) {
        return SparqlDLExecutionFactory.create(query2, DatasetFactory.create(model), initialBinding);
    }

    public static QueryExecution createPelletExecution(Query query2, Model model) {
        return SparqlDLExecutionFactory.create(query2, DatasetFactory.create(model), null, QueryEngineType.PELLET);
    }

    public static QueryExecution createPelletExecution(Query query2, Model model, QuerySolution initialBinding) {
        return SparqlDLExecutionFactory.create(query2, DatasetFactory.create(model), initialBinding, QueryEngineType.PELLET);
    }

    public static QueryExecution createPelletExecution(Query query2, Dataset dataset) {
        return SparqlDLExecutionFactory.create(query2, dataset, null, QueryEngineType.PELLET);
    }

    public static QueryExecution createPelletExecution(Query query2, Dataset dataset, QuerySolution initialBinding) {
        return SparqlDLExecutionFactory.create(query2, dataset, initialBinding, QueryEngineType.PELLET);
    }

    @Deprecated
    public static QueryExecution createBasicExecution(Query query2, Model model) {
        return SparqlDLExecutionFactory.createPelletExecution(query2, model);
    }

    @Deprecated
    public static QueryExecution createBasicExecution(Query query2, Dataset dataset) {
        return SparqlDLExecutionFactory.createPelletExecution(query2, dataset);
    }

    public static enum QueryEngineType {
        ARQ,
        MIXED,
        PELLET;

    }
}

