/*
 * Decompiled with CFR 0.152.
 */
package openllet.query.sparqldl.jena;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import openllet.aterm.ATermAppl;
import openllet.core.exceptions.UnsupportedQueryException;
import openllet.core.utils.ATermUtils;
import openllet.jena.PelletInfGraph;
import openllet.jena.graph.loader.GraphLoader;
import openllet.query.sparqldl.engine.QueryEngine;
import openllet.query.sparqldl.jena.SparqlDLResultSet;
import openllet.query.sparqldl.model.Query;
import openllet.query.sparqldl.model.QueryResult;
import openllet.query.sparqldl.model.ResultBinding;
import openllet.query.sparqldl.model.ResultBindingImpl;
import openllet.query.sparqldl.parser.ARQParser;
import openllet.shared.tools.Log;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIterRepeatApply;
import org.apache.jena.sparql.engine.iterator.QueryIteratorResultSet;
import org.apache.jena.sparql.engine.main.StageGeneratorGeneric;

class SparqlDLStage {
    public static final Logger _logger = Log.getLogger(SparqlDLStage.class);
    private final ARQParser _parser;
    private final BasicPattern _pattern;
    private Collection<String> _vars;

    public SparqlDLStage(BasicPattern pattern) {
        this(pattern, true);
    }

    public SparqlDLStage(BasicPattern pattern, boolean handleVariableSPO) {
        this._pattern = pattern;
        this._parser = new ARQParser(handleVariableSPO);
        this.initVars();
    }

    private void initVars() {
        this._vars = new LinkedHashSet<String>();
        for (int i = 0; i < this._pattern.size(); ++i) {
            Triple t = this._pattern.get(i);
            if (ARQParser.isDistinguishedVariable(t.getSubject())) {
                this._vars.add(t.getSubject().getName());
            }
            if (t.getPredicate().isVariable()) {
                this._vars.add(t.getPredicate().getName());
            }
            if (!ARQParser.isDistinguishedVariable(t.getObject())) continue;
            this._vars.add(t.getObject().getName());
        }
    }

    public QueryIterator build(QueryIterator input, ExecutionContext execCxt) {
        Graph graph = execCxt.getActiveGraph();
        if (!(graph instanceof PelletInfGraph)) {
            throw new UnsupportedOperationException("A Pellet-backed model is required");
        }
        PelletInfGraph pellet = (PelletInfGraph)graph;
        pellet.prepare();
        Query query2 = this.parsePattern(pellet);
        if (query2 != null) {
            return new PelletQueryIterator(pellet, query2, input, execCxt);
        }
        return new StageGeneratorGeneric().execute(this._pattern, input, execCxt);
    }

    private Query parsePattern(PelletInfGraph pellet) {
        try {
            return this._parser.parse(this._pattern, this._vars, pellet.getKB(), false);
        }
        catch (UnsupportedQueryException e2) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Falling back to Jena stage", e2);
            }
            return null;
        }
    }

    private static class PelletQueryIterator
    extends QueryIterRepeatApply {
        private final PelletInfGraph _pellet;
        private final Query _query;

        public PelletQueryIterator(PelletInfGraph pellet, Query query2, QueryIterator input, ExecutionContext execCxt) {
            super(input, execCxt);
            this._pellet = pellet;
            this._query = query2;
        }

        private ResultBinding convertBinding(Binding binding) {
            ResultBindingImpl pelletBinding = new ResultBindingImpl();
            GraphLoader loader = this._pellet.getLoader();
            Iterator<Var> vars = binding.vars();
            while (vars.hasNext()) {
                Var var = vars.next();
                Node value = binding.get(var);
                if (value == null) continue;
                ATermAppl pelletVar = ATermUtils.makeVar(var.getVarName());
                ATermAppl pelletValue = loader.node2term(value);
                pelletBinding.setValue(pelletVar, pelletValue);
            }
            return pelletBinding;
        }

        @Override
        protected QueryIterator nextStage(Binding binding) {
            Query newQuery = this._query.apply(this.convertBinding(binding));
            QueryResult results = QueryEngine.exec(newQuery);
            SparqlDLResultSet resultSet = new SparqlDLResultSet(results, null, binding);
            QueryIteratorResultSet iter = new QueryIteratorResultSet(resultSet);
            return iter;
        }
    }
}

