/*
 * Decompiled with CFR 0.152.
 */
package openllet.query.sparqldl.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermList;
import openllet.atom.OpenError;
import openllet.core.KnowledgeBase;
import openllet.core.exceptions.InternalReasonerException;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.TermFactory;
import openllet.query.sparqldl.model.Filter;
import openllet.query.sparqldl.model.Query;
import openllet.query.sparqldl.model.QueryAtom;
import openllet.query.sparqldl.model.QueryParameters;
import openllet.query.sparqldl.model.QueryPredicate;
import openllet.query.sparqldl.model.ResultBinding;

public class QueryImpl
implements Query {
    private static final ATermAppl DEFAULT_NAME = TermFactory.term("query");
    private ATermAppl _name = DEFAULT_NAME;
    private final List<QueryAtom> _allAtoms;
    private KnowledgeBase _kb;
    private List<ATermAppl> _resultVars;
    private Set<ATermAppl> _allVars;
    private Set<ATermAppl> _individualsAndLiterals;
    private boolean _ground;
    private final boolean _distinct;
    private Filter _filter;
    private QueryParameters _parameters;
    private EnumMap<Query.VarType, Set<ATermAppl>> _distVars;

    public QueryImpl(KnowledgeBase kb, boolean distinct) {
        this._kb = kb;
        this._ground = true;
        this._allAtoms = new ArrayList<QueryAtom>();
        this._resultVars = new ArrayList<ATermAppl>();
        this._allVars = new HashSet<ATermAppl>();
        this._individualsAndLiterals = new HashSet<ATermAppl>();
        this._distVars = new EnumMap(Query.VarType.class);
        for (Query.VarType type : Query.VarType.values()) {
            this._distVars.put(type, new HashSet());
        }
        this._distinct = distinct;
    }

    public QueryImpl(Query query2) {
        this(query2.getKB(), query2.isDistinct());
        this._name = query2.getName();
        this._parameters = query2.getQueryParameters();
    }

    @Override
    public void add(QueryAtom atom) {
        if (this._allAtoms.contains(atom)) {
            return;
        }
        this._allAtoms.add(atom);
        for (ATermAppl a : atom.getArguments()) {
            if (ATermUtils.isVar(a)) {
                if (this._allVars.contains(a)) continue;
                this._allVars.add(a);
                continue;
            }
            if (!ATermUtils.isLiteral(a) && !this._kb.isIndividual(a) || this._individualsAndLiterals.contains(a)) continue;
            this._individualsAndLiterals.add(a);
        }
        this._ground = this._ground && atom.isGround();
    }

    @Override
    public Set<ATermAppl> getDistVarsForType(Query.VarType type) {
        return this._distVars.get((Object)type);
    }

    @Override
    public void addDistVar(ATermAppl a, Query.VarType type) {
        Set<ATermAppl> set = this._distVars.get((Object)type);
        if (!set.contains(a)) {
            set.add(a);
        }
    }

    @Override
    public void addResultVar(ATermAppl a) {
        this._resultVars.add(a);
    }

    @Override
    public List<QueryAtom> getAtoms() {
        return Collections.unmodifiableList(this._allAtoms);
    }

    @Override
    public Set<ATermAppl> getConstants() {
        return Collections.unmodifiableSet(this._individualsAndLiterals);
    }

    @Override
    public Set<ATermAppl> getDistVars() {
        HashSet<ATermAppl> result = new HashSet<ATermAppl>();
        for (Query.VarType t : Query.VarType.values()) {
            result.addAll((Collection<ATermAppl>)this._distVars.get((Object)t));
        }
        return result;
    }

    @Override
    public Set<ATermAppl> getUndistVars() {
        HashSet<ATermAppl> result = new HashSet<ATermAppl>(this._allVars);
        result.removeAll(this.getDistVars());
        return result;
    }

    @Override
    public List<ATermAppl> getResultVars() {
        return Collections.unmodifiableList(this._resultVars);
    }

    @Override
    public Set<ATermAppl> getVars() {
        return Collections.unmodifiableSet(this._allVars);
    }

    @Override
    public boolean isGround() {
        return this._ground;
    }

    @Override
    public KnowledgeBase getKB() {
        return this._kb;
    }

    @Override
    public void setKB(KnowledgeBase kb) {
        this._kb = kb;
    }

    @Override
    public Query apply(ResultBinding binding) {
        ArrayList<QueryAtom> atoms = new ArrayList<QueryAtom>();
        for (QueryAtom atom : this.getAtoms()) {
            atoms.add(atom.apply(binding));
        }
        QueryImpl query2 = new QueryImpl(this);
        query2._resultVars.addAll(this._resultVars);
        query2._resultVars.removeAll(binding.getAllVariables());
        for (Query.VarType type : Query.VarType.values()) {
            for (ATermAppl atom : this.getDistVarsForType(type)) {
                if (binding.isBound(atom)) continue;
                query2.addDistVar(atom, type);
            }
        }
        for (QueryAtom atom : atoms) {
            query2.add(atom);
        }
        return query2;
    }

    @Override
    public ATermAppl rollUpTo(ATermAppl var, Collection<ATermAppl> stopList, boolean stopOnConstants) {
        if (this.getDistVarsForType(Query.VarType.LITERAL).contains(var) && !this.getDistVarsForType(Query.VarType.INDIVIDUAL).contains(var) && !this._individualsAndLiterals.contains(var)) {
            throw new InternalReasonerException("Trying to roll up to the variable '" + var + "' which is not distinguished and _individual.");
        }
        ATermList classParts = ATermUtils.EMPTY_LIST;
        HashSet<ATermAppl> visited = new HashSet<ATermAppl>();
        if (stopOnConstants) {
            visited.addAll(this.getConstants());
        }
        List<QueryAtom> inEdges = this.findAtoms(QueryPredicate.PropertyValue, null, null, var);
        for (QueryAtom a : inEdges) {
            classParts = classParts.append(this.rollEdgeIn(QueryPredicate.PropertyValue, a, visited, stopList));
        }
        List<QueryAtom> outEdges = this.findAtoms(QueryPredicate.PropertyValue, var, null, null);
        for (QueryAtom a : outEdges) {
            classParts = classParts.append(this.rollEdgeOut(QueryPredicate.PropertyValue, a, visited, stopList));
        }
        classParts = classParts.concat(this.getClasses(var));
        return ATermUtils.makeAnd(classParts);
    }

    private ATermList getClasses(ATermAppl a) {
        ArrayList<ATermAppl> aterms = new ArrayList<ATermAppl>();
        for (QueryAtom atom : this.findAtoms(QueryPredicate.Type, a, null)) {
            ATermAppl arg = atom.getArguments().get(1);
            if (ATermUtils.isVar(arg)) {
                throw new InternalReasonerException("Variables as predicates are not supported yet");
            }
            aterms.add(arg);
        }
        if (!ATermUtils.isVar(a)) {
            aterms.add(ATermUtils.makeValue(a));
        }
        return ATermUtils.makeList(aterms);
    }

    private ATermAppl rollEdgeOut(QueryPredicate allowed, QueryAtom atom, Set<ATermAppl> visited, Collection<ATermAppl> stopList) {
        switch (atom.getPredicate()) {
            case PropertyValue: {
                ATermList outs;
                ATermAppl subj = atom.getArguments().get(0);
                ATermAppl pred = atom.getArguments().get(1);
                ATermAppl obj = atom.getArguments().get(2);
                if (ATermUtils.isVar(pred)) {
                    return ATermUtils.TOP;
                }
                visited.add(subj);
                if (visited.contains(obj)) {
                    ATermList temp = this.getClasses(obj);
                    if (temp.getLength() == 0) {
                        if (this._kb.isDatatypeProperty(pred)) {
                            return ATermUtils.makeSomeValues(pred, ATermUtils.TOP_LIT);
                        }
                        return ATermUtils.makeSomeValues(pred, ATermUtils.TOP);
                    }
                    return ATermUtils.makeSomeValues(pred, ATermUtils.makeAnd(temp));
                }
                if (ATermUtils.isLiteral(obj)) {
                    ATermAppl type = ATermUtils.makeValue(obj);
                    return ATermUtils.makeSomeValues(pred, type);
                }
                ATermList targetClasses = this.getClasses(obj);
                for (QueryAtom in : this._findAtoms(stopList, allowed, null, null, obj)) {
                    if (in.equals(atom)) continue;
                    targetClasses = targetClasses.append(this.rollEdgeIn(allowed, in, visited, stopList));
                }
                List<QueryAtom> targetOuts = this._findAtoms(stopList, allowed, obj, null, null);
                if (targetClasses.isEmpty()) {
                    if (targetOuts.size() == 0) {
                        if (this._kb.isDatatypeProperty(pred)) {
                            return ATermUtils.makeSomeValues(pred, ATermUtils.TOP_LIT);
                        }
                        return ATermUtils.makeSomeValues(pred, ATermUtils.TOP);
                    }
                    outs = ATermUtils.EMPTY_LIST;
                    for (QueryAtom currEdge : targetOuts) {
                        outs = outs.append(this.rollEdgeOut(allowed, currEdge, visited, stopList));
                    }
                    return ATermUtils.makeSomeValues(pred, ATermUtils.makeAnd(outs));
                }
                if (targetOuts.size() == 0) {
                    return ATermUtils.makeSomeValues(pred, ATermUtils.makeAnd(targetClasses));
                }
                outs = ATermUtils.EMPTY_LIST;
                for (QueryAtom currEdge : targetOuts) {
                    outs = outs.append(this.rollEdgeOut(allowed, currEdge, visited, stopList));
                }
                for (int i = 0; i < targetClasses.getLength(); ++i) {
                    outs = outs.append((ATerm)targetClasses.elementAt(i));
                }
                return ATermUtils.makeSomeValues(pred, ATermUtils.makeAnd(outs));
            }
        }
        throw new OpenError("This atom cannot be included to rolling-up : " + atom);
    }

    /*
     * WARNING - void declaration
     */
    private ATermAppl rollEdgeIn(QueryPredicate allowed, QueryAtom atom, Set<ATermAppl> visited, Collection<ATermAppl> stopList) {
        switch (atom.getPredicate()) {
            case PropertyValue: {
                void var12_17;
                ATermList ins;
                ATermAppl subj = atom.getArguments().get(0);
                ATermAppl pred = atom.getArguments().get(1);
                ATermAppl obj = atom.getArguments().get(2);
                ATermAppl invPred = this._kb.getRBox().getRole(pred).getInverse().getName();
                if (ATermUtils.isVar(pred)) {
                    throw new InternalReasonerException("Variables as predicates are not supported yet");
                }
                visited.add(obj);
                if (visited.contains(subj)) {
                    ATermList temp = this.getClasses(subj);
                    if (temp.getLength() == 0) {
                        if (this._kb.isDatatypeProperty(invPred)) {
                            return ATermUtils.makeSomeValues(invPred, ATermUtils.TOP_LIT);
                        }
                        return ATermUtils.makeSomeValues(invPred, ATermUtils.TOP);
                    }
                    return ATermUtils.makeSomeValues(invPred, ATermUtils.makeAnd(temp));
                }
                ATermList targetClasses = this.getClasses(subj);
                List<QueryAtom> targetIns = this._findAtoms(stopList, allowed, null, null, subj);
                for (QueryAtom queryAtom : this._findAtoms(stopList, allowed, subj, null, null)) {
                    if (queryAtom.equals(atom)) continue;
                    targetClasses = targetClasses.append(this.rollEdgeOut(allowed, queryAtom, visited, stopList));
                }
                if (targetClasses.isEmpty()) {
                    if (targetIns.isEmpty()) {
                        if (this._kb.isDatatypeProperty(pred)) {
                            return ATermUtils.makeSomeValues(invPred, ATermUtils.TOP_LIT);
                        }
                        return ATermUtils.makeSomeValues(invPred, ATermUtils.TOP);
                    }
                    ins = ATermUtils.EMPTY_LIST;
                    for (QueryAtom currEdge : targetIns) {
                        ins = ins.append(this.rollEdgeIn(allowed, currEdge, visited, stopList));
                    }
                    return ATermUtils.makeSomeValues(invPred, ATermUtils.makeAnd(ins));
                }
                if (targetIns.isEmpty()) {
                    return ATermUtils.makeSomeValues(invPred, ATermUtils.makeAnd(targetClasses));
                }
                ins = ATermUtils.EMPTY_LIST;
                for (QueryAtom currEdge : targetIns) {
                    ins = ins.append(this.rollEdgeIn(allowed, currEdge, visited, stopList));
                }
                boolean bl = false;
                while (var12_17 < targetClasses.getLength()) {
                    ins = ins.append((ATerm)targetClasses.elementAt((int)var12_17));
                    ++var12_17;
                }
                return ATermUtils.makeSomeValues(invPred, ATermUtils.makeAnd(ins));
            }
        }
        throw new OpenError("This atom cannot be included to rolling-up : " + atom);
    }

    private List<QueryAtom> _findAtoms(Collection<ATermAppl> stopList, QueryPredicate predicate, ATermAppl ... args) {
        ArrayList<QueryAtom> list = new ArrayList<QueryAtom>();
        for (QueryAtom atom : this._allAtoms) {
            if (!predicate.equals((Object)atom.getPredicate())) continue;
            int i = 0;
            boolean add = true;
            for (ATermAppl arg : atom.getArguments()) {
                ATermAppl argValue;
                if (((argValue = args[i++]) == null || argValue == arg) && !stopList.contains(arg)) continue;
                add = false;
                break;
            }
            if (!add) continue;
            list.add(atom);
        }
        return list;
    }

    @Override
    public List<QueryAtom> findAtoms(QueryPredicate predicate, ATermAppl ... args) {
        return this._findAtoms(Collections.emptySet(), predicate, args);
    }

    @Override
    public Query reorder(int[] ordering) {
        if (ordering.length != this._allAtoms.size()) {
            throw new InternalReasonerException("Ordering permutation must be of the same size as the query : " + ordering.length);
        }
        QueryImpl newQuery = new QueryImpl(this);
        for (int element : ordering) {
            newQuery._allAtoms.add(this._allAtoms.get(element));
        }
        newQuery._allVars = this._allVars;
        newQuery._distVars = this._distVars;
        newQuery._individualsAndLiterals = this._individualsAndLiterals;
        newQuery._resultVars = this._resultVars;
        newQuery._ground = this._ground;
        return newQuery;
    }

    @Override
    public void remove(QueryAtom atom) {
        if (!this._allAtoms.contains(atom)) {
            return;
        }
        this._allAtoms.remove(atom);
        HashSet<ATermAppl> rest = new HashSet<ATermAppl>();
        boolean ground = true;
        for (QueryAtom atom2 : this._allAtoms) {
            ground &= atom2.isGround();
            rest.addAll(atom2.getArguments());
        }
        this._ground = ground;
        HashSet<ATermAppl> toRemove = new HashSet<ATermAppl>(atom.getArguments());
        toRemove.removeAll(rest);
        for (ATermAppl a : toRemove) {
            this._allVars.remove(a);
            for (Map.Entry<Query.VarType, Set<ATermAppl>> entry : this._distVars.entrySet()) {
                entry.getValue().remove(a);
            }
            this._resultVars.remove(a);
            this._individualsAndLiterals.remove(a);
        }
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean multiLine) {
        int i;
        String indent = multiLine ? "     " : " ";
        StringBuffer sb = new StringBuffer();
        sb.append(ATermUtils.toString(this._name) + "(");
        for (i = 0; i < this._resultVars.size(); ++i) {
            ATermAppl var = this._resultVars.get(i);
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(ATermUtils.toString(var));
        }
        sb.append(")");
        if (this._allAtoms.size() > 0) {
            sb.append(" :-");
            if (multiLine) {
                sb.append("\n");
            }
            for (i = 0; i < this._allAtoms.size(); ++i) {
                QueryAtom a = this._allAtoms.get(i);
                if (i > 0) {
                    sb.append(",");
                    if (multiLine) {
                        sb.append("\n");
                    }
                }
                sb.append(indent);
                sb.append(a.toString());
            }
        }
        sb.append(".");
        if (multiLine) {
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public boolean isDistinct() {
        return this._distinct;
    }

    @Override
    public Filter getFilter() {
        return this._filter;
    }

    @Override
    public void setFilter(Filter filter) {
        this._filter = filter;
    }

    @Override
    public void setQueryParameters(QueryParameters parameters) {
        this._parameters = parameters;
    }

    @Override
    public QueryParameters getQueryParameters() {
        return this._parameters;
    }

    @Override
    public ATermAppl getName() {
        return this._name;
    }

    @Override
    public void setName(ATermAppl name) {
        this._name = name;
    }
}

