/*
 * Decompiled with CFR 0.152.
 */
package openllet.query.sparqldl.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import openllet.aterm.ATermAppl;
import openllet.query.sparqldl.model.Query;
import openllet.query.sparqldl.model.QueryParameters;
import openllet.query.sparqldl.model.QueryResult;
import openllet.query.sparqldl.model.ResultBinding;

public class QueryResultImpl
implements QueryResult {
    private Collection<ResultBinding> _bindings;
    private final List<ATermAppl> _resultVars;
    private final Query _query;
    private final QueryParameters _parameters;

    public QueryResultImpl(Query query2) {
        this._query = query2;
        this._parameters = query2.getQueryParameters();
        this._resultVars = new ArrayList<ATermAppl>(query2.getResultVars());
        this._bindings = query2.isDistinct() ? new HashSet<ResultBinding>() : new ArrayList<ResultBinding>();
    }

    @Override
    public void add(ResultBinding binding) {
        this._bindings.add(this.process(binding));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QueryResultImpl other = (QueryResultImpl)obj;
        if (this._bindings == null ? other._bindings != null : !this._bindings.equals(other._bindings)) {
            return false;
        }
        return !(this._resultVars == null ? other._resultVars != null : !this._resultVars.equals(other._resultVars));
    }

    @Override
    public List<ATermAppl> getResultVars() {
        return Collections.unmodifiableList(this._resultVars);
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this._bindings == null ? 0 : this._bindings.hashCode());
        result = 31 * result + (this._resultVars == null ? 0 : this._resultVars.hashCode());
        return result;
    }

    @Override
    public boolean isDistinct() {
        return this._bindings instanceof Set;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<ResultBinding> iterator() {
        return this._bindings.iterator();
    }

    @Override
    public int size() {
        return this._bindings.size();
    }

    public String toString() {
        return this._bindings.toString();
    }

    private ResultBinding process(ResultBinding binding) {
        if (this._parameters == null) {
            return binding;
        }
        int numOfVars = this._query.getResultVars().size();
        for (Map.Entry<ATermAppl, ATermAppl> entry : this._parameters.entrySet()) {
            ATermAppl var = entry.getKey();
            ATermAppl value = entry.getValue();
            if (numOfVars != 0 && !this._query.getResultVars().contains(var)) continue;
            binding.setValue(var, value);
        }
        return binding;
    }
}

