/*
 * Decompiled with CFR 0.152.
 */
package openllet.reachability;

import openllet.reachability.Node;

public class AndNode
extends Node {
    private int _activatedInputs;
    private final int _id;

    public AndNode(int id) {
        this._id = id;
        this._activatedInputs = 0;
    }

    @Override
    public boolean inputActivated() {
        return ++this._activatedInputs == this._inputs.size();
    }

    @Override
    public boolean isActive() {
        return this._activatedInputs == this._inputs.size();
    }

    @Override
    public boolean isRedundant() {
        return this._outputs.isEmpty() || this._inputs.size() == 1 || this._outputs.size() == 1 && this._outputs.iterator().next() instanceof AndNode;
    }

    @Override
    public void reset() {
        this._activatedInputs = 0;
    }

    public String toString() {
        return "And(" + this._id + ")[" + this._activatedInputs + "," + this._inputs.size() + "]";
    }
}

