/*
 * Decompiled with CFR 0.152.
 */
package openllet.reachability;

import java.util.Collections;
import java.util.Set;
import openllet.core.utils.SetUtils;
import openllet.reachability.Node;

public class EntityNode<E>
extends Node {
    private boolean _active = false;
    private Set<E> _entities;

    public EntityNode(E entity) {
        this._entities = Collections.singleton(entity);
    }

    public void addEntities(Set<E> entity) {
        if (this._entities.size() == 1) {
            this._entities = SetUtils.create(this._entities);
        }
        this._entities.addAll(entity);
    }

    public void addEntity(E entity) {
        if (this._entities.size() == 1) {
            this._entities = SetUtils.create(this._entities);
        }
        this._entities.add(entity);
    }

    public Set<E> getEntities() {
        return this._entities;
    }

    @Override
    public boolean inputActivated() {
        return this._active ? false : (this._active = true);
    }

    @Override
    public boolean isActive() {
        return this._active;
    }

    @Override
    public void reset() {
        this._active = false;
    }

    public String toString() {
        return this._entities.toString();
    }

    @Override
    public boolean isEntityNode() {
        return true;
    }
}

