/*
 * Decompiled with CFR 0.152.
 */
package openllet.reachability;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Stream;
import openllet.core.utils.SetUtils;
import openllet.reachability.EntityNode;

public abstract class Node {
    protected volatile Set<Node> _outputs = SetUtils.create();
    protected volatile Set<Node> _inputs = SetUtils.create();

    public void addOutput(Node output) {
        if (output.equals(this)) {
            return;
        }
        if (this._outputs.add(output)) {
            output._inputs.add(this);
        }
    }

    public boolean hasOutput(Node node) {
        return this._outputs.contains(node);
    }

    public Set<Node> getInputs() {
        return Collections.unmodifiableSet(this._inputs);
    }

    public Stream<Node> inputs() {
        return this._inputs.stream();
    }

    public Set<Node> getOutputs() {
        return Collections.unmodifiableSet(this._outputs);
    }

    public Stream<Node> outputs() {
        return this._outputs.stream();
    }

    public abstract boolean inputActivated();

    public abstract boolean isActive();

    public boolean isRedundant() {
        return false;
    }

    public void removeOutput(Node output) {
        if (this._outputs.remove(output)) {
            output._inputs.remove(output);
        }
    }

    public void removeInOuts() {
        this._inputs.forEach(input -> input._outputs.remove(this));
        this._inputs = null;
        this._outputs.forEach(input -> input._inputs.remove(this));
        this._outputs = null;
    }

    public void remove() {
        this._inputs.forEach(input -> {
            input._outputs.remove(this);
            this._outputs.forEach(input::addOutput);
        });
        this._outputs.forEach(output -> output._inputs.remove(this));
        this._inputs = null;
        this._outputs = null;
    }

    public abstract void reset();

    public boolean isEntityNode() {
        return false;
    }

    public <X> EntityNode<X> asEntityNode() {
        return (EntityNode)this;
    }
}

