/*
 * Decompiled with CFR 0.152.
 */
package openllet.reachability;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class PairSet<T>
extends AbstractSet<T> {
    private final Set<T> _firstSet;
    private final Set<T> _secondSet;
    private final int _size;

    public PairSet(Set<T> first, Set<T> second) {
        this._firstSet = first;
        this._secondSet = second;
        this._size = this.computeUnionSize();
    }

    private int computeUnionSize() {
        int size = this._firstSet.size() + this._secondSet.size();
        if (this._firstSet.size() < this._secondSet.size()) {
            for (T e2 : this._firstSet) {
                if (!this._secondSet.contains(e2)) continue;
                --size;
            }
        } else {
            for (T e3 : this._secondSet) {
                if (!this._firstSet.contains(e3)) continue;
                --size;
            }
        }
        return size;
    }

    @Override
    public boolean add(T o) {
        throw new UnsupportedOperationException("Pair sets are read-only");
    }

    @Override
    public boolean contains(Object o) {
        return this._firstSet.contains(o) || this._secondSet.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return new PairIterator();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Pair sets are read-only");
    }

    @Override
    public int size() {
        return this._size;
    }

    public class PairIterator
    implements Iterator<T> {
        private Set<T> firstIteratedSet;
        private Iterator<T> firstIterator;
        private Iterator<T> secondIterator;
        private T next;

        public PairIterator() {
            if (PairSet.this._firstSet.size() < PairSet.this._secondSet.size()) {
                this.firstIteratedSet = PairSet.this._firstSet;
                this.firstIterator = PairSet.this._firstSet.iterator();
                this.secondIterator = PairSet.this._secondSet.iterator();
            } else {
                this.firstIteratedSet = PairSet.this._secondSet;
                this.firstIterator = PairSet.this._secondSet.iterator();
                this.secondIterator = PairSet.this._firstSet.iterator();
            }
            this.findNext();
        }

        private void findNext() {
            if (this.firstIterator.hasNext()) {
                this.next = this.firstIterator.next();
            } else {
                this.next = null;
                while (this.secondIterator.hasNext() && this.next == null) {
                    this.next = this.secondIterator.next();
                    if (!this.firstIteratedSet.contains(this.next)) continue;
                    this.next = null;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object result = this.next;
            this.findNext();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

