/*
 * Decompiled with CFR 0.152.
 */
package openllet.reachability;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import openllet.reachability.EntityNode;
import openllet.reachability.Node;
import openllet.reachability.ReachabilityGraph;
import openllet.shared.tools.Log;

public class Reachability<E> {
    public static final Logger _logger = Log.getLogger(Reachability.class);
    private final ReachabilityGraph<E> _graph;
    private Set<E> _activatedEntities;
    private Set<Node> _affectedNodes;
    private Queue<Node> _waitingQueue;

    public Reachability(ReachabilityGraph<E> graph) {
        this._graph = graph;
    }

    public ReachabilityGraph<E> getGraph() {
        return this._graph;
    }

    private void reset() {
        this._activatedEntities = new HashSet();
        this._affectedNodes = new HashSet<Node>();
        this._waitingQueue = new LinkedList<Node>();
        this._waitingQueue.add(this._graph.getStartNode());
    }

    private void activateNode(EntityNode<E> node) {
        if (node.isActive()) {
            throw new IllegalStateException();
        }
        this._affectedNodes.add(node);
        this._activatedEntities.addAll(node.getEntities());
        this._waitingQueue.add(node);
        node.inputActivated();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Activated: " + node);
        }
    }

    public boolean contains(E entity) {
        return this._graph.getNode(entity) != null;
    }

    public Set<E> computeReachable(Iterable<E> initialEntities) {
        this.reset();
        for (Object initialEntity : initialEntities) {
            EntityNode<E> initialNode = this._graph.getNode(initialEntity);
            if (initialNode == null) {
                throw new IllegalArgumentException("Unknown entity: " + initialEntity);
            }
            if (initialNode.isActive()) continue;
            this.activateNode(initialNode);
        }
        while (!this._waitingQueue.isEmpty()) {
            Node node = this._waitingQueue.poll();
            assert (node.isActive());
            for (Node outputNode : node.getOutputs()) {
                if (outputNode.isActive()) {
                    if (!_logger.isLoggable(Level.FINE)) continue;
                    _logger.fine("Already activated: " + outputNode);
                    continue;
                }
                this._affectedNodes.add(outputNode);
                if (!outputNode.inputActivated()) continue;
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("Activated: " + outputNode);
                }
                this._waitingQueue.add(outputNode);
                if (!(outputNode instanceof EntityNode)) continue;
                this._activatedEntities.addAll(this.entityNode(outputNode).getEntities());
            }
        }
        for (Node node : this._affectedNodes) {
            node.reset();
        }
        return this._activatedEntities;
    }

    private EntityNode<E> entityNode(Node node) {
        return (EntityNode)node;
    }
}

