/*
 * Decompiled with CFR 0.152.
 */
package openllet.reachability;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import openllet.reachability.AndNode;
import openllet.reachability.EntityNode;
import openllet.reachability.Node;
import openllet.reachability.OrNode;
import openllet.reachability.SCC;
import openllet.shared.tools.Log;

public class ReachabilityGraph<E> {
    public static final Logger _logger = Log.getLogger(ReachabilityGraph.class);
    private final Map<E, EntityNode<E>> _entityNodes = new ConcurrentHashMap<E, EntityNode<E>>();
    private int _id = 0;
    private final Node _startNode = new Node(){

        @Override
        public boolean inputActivated() {
            return false;
        }

        @Override
        public boolean isActive() {
            return true;
        }

        @Override
        public void reset() {
        }

        public String toString() {
            return "START";
        }
    };
    private final Node nullNode = new Node(){

        @Override
        public boolean inputActivated() {
            throw new IllegalStateException("NULL node cannot have inputs");
        }

        @Override
        public void addOutput(Node output) {
        }

        @Override
        public boolean isActive() {
            return false;
        }

        @Override
        public void reset() {
        }

        public String toString() {
            return "NULL";
        }
    };

    public Node createAndNode(Set<Node> inputs) {
        if (inputs.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (inputs.contains(this.getNullNode())) {
            return this.getNullNode();
        }
        inputs.remove(this.getStartNode());
        int size = inputs.size();
        if (size == 0) {
            return this.getStartNode();
        }
        if (size == 1) {
            return inputs.iterator().next();
        }
        AndNode andNode = new AndNode(this._id++);
        for (Node input : inputs) {
            input.addOutput(andNode);
        }
        return andNode;
    }

    public EntityNode<E> createEntityNode(E entity) {
        EntityNode<E> node = this._entityNodes.get(entity);
        if (node == null) {
            node = new EntityNode<E>(entity);
            this._entityNodes.put(entity, node);
        }
        return node;
    }

    public Node createOrNode(Set<Node> inputs) {
        if (inputs.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (inputs.contains(this.getStartNode())) {
            return this.getStartNode();
        }
        inputs.remove(this.getNullNode());
        int size = inputs.size();
        if (size == 0) {
            return this.getNullNode();
        }
        if (size == 1) {
            return inputs.iterator().next();
        }
        OrNode orNode = new OrNode(this._id++);
        for (Node input : inputs) {
            input.addOutput(orNode);
        }
        return orNode;
    }

    public Set<E> getEntities() {
        return this._entityNodes.keySet();
    }

    public Collection<EntityNode<E>> getEntityNodes() {
        return this._entityNodes.values();
    }

    public EntityNode<E> getNode(E entity) {
        return this._entityNodes.get(entity);
    }

    public Node getNullNode() {
        return this.nullNode;
    }

    public Node getStartNode() {
        return this._startNode;
    }

    public void simplify() {
        this.collapseSCC();
        this.removeRedundancies();
    }

    private void collapseSCC() {
        int count = 0;
        List components = SCC.computeSCC(this);
        for (Set component : components) {
            if (component.size() == 1) continue;
            if (_logger.isLoggable(Level.FINER)) {
                _logger.finer("Merging " + component);
            }
            Iterator i = component.iterator();
            EntityNode rep = i.next();
            while (i.hasNext()) {
                EntityNode node = i.next();
                for (Object entity : node.getEntities()) {
                    rep.addEntity(entity);
                    this._entityNodes.put(entity, rep);
                }
                for (Node input : node.getInputs()) {
                    input.addOutput(rep);
                }
                for (Node output : node.getOutputs()) {
                    rep.addOutput(output);
                }
                node.removeInOuts();
                ++count;
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Merged " + count + " nodes");
        }
    }

    private void removeRedundancies() {
        int removedNode = -1;
        int removedEdge = -1;
        while (removedNode != 0) {
            removedNode = 0;
            removedEdge = 0;
            for (Node node : this._entityNodes.values()) {
                for (Node out : node.getOutputs().toArray(new Node[0])) {
                    if (out.isRedundant()) {
                        out.remove();
                        ++removedNode;
                        continue;
                    }
                    if (!(out instanceof AndNode) || !out.hasOutput(node)) continue;
                    out.removeOutput(node);
                    ++removedEdge;
                }
            }
            if (!_logger.isLoggable(Level.FINE)) continue;
            _logger.fine("Removed " + removedNode + " nodes and " + removedEdge + " edges");
        }
    }
}

