/*
 * Decompiled with CFR 0.152.
 */
package openllet.reachability;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import openllet.core.utils.SetUtils;
import openllet.reachability.AndNode;
import openllet.reachability.EntityNode;
import openllet.reachability.Node;
import openllet.reachability.ReachabilityGraph;

public class SCC {
    private SCC() {
    }

    public static <E> List<Set<EntityNode<E>>> computeSCC(ReachabilityGraph<E> graph) {
        return new SCCComputer<E>().computeSCC(graph);
    }

    private static class SCCComputer<E> {
        private final List<Set<EntityNode<E>>> _stronglyConnectedComponents = new ArrayList<Set<EntityNode<E>>>();
        private int _index;
        private ArrayList<NodeInfo> _stack;
        private final Map<Node, NodeInfo> _nodeInfos = new ConcurrentHashMap<Node, NodeInfo>();

        private SCCComputer() {
        }

        public List<Set<EntityNode<E>>> computeSCC(ReachabilityGraph<E> graph) {
            Collection<EntityNode<E>> nodes = graph.getEntityNodes();
            for (Node node : nodes) {
                if (this._nodeInfos.containsKey(node)) continue;
                this.computeSCC(node);
            }
            return this._stronglyConnectedComponents;
        }

        private void computeSCC(Node node) {
            this._index = 0;
            this._stack = new ArrayList();
            this.visit(new NodeInfo(node));
        }

        private void visit(NodeInfo nodeInfo) {
            this._nodeInfos.put(nodeInfo._node, nodeInfo);
            nodeInfo._index = this._index;
            nodeInfo._lowlink = this._index;
            ++this._index;
            this._stack.add(nodeInfo);
            nodeInfo._onStack = true;
            for (Node out : nodeInfo._node.getOutputs()) {
                if (out instanceof AndNode) continue;
                NodeInfo outInfo = this._nodeInfos.get(out);
                if (outInfo == null) {
                    outInfo = new NodeInfo(out);
                    this.visit(outInfo);
                    nodeInfo._lowlink = Math.min(nodeInfo._lowlink, outInfo._lowlink);
                    continue;
                }
                if (!outInfo._onStack) continue;
                nodeInfo._lowlink = Math.min(nodeInfo._lowlink, outInfo._index);
            }
            if (nodeInfo._lowlink == nodeInfo._index) {
                Set connectedComponent = SetUtils.create();
                int i = this._stack.size() - 1;
                NodeInfo info = null;
                while (info != nodeInfo) {
                    info = this._stack.get(i);
                    info._onStack = false;
                    if (info.isEntityNode()) {
                        connectedComponent.add(info.asEntityNode());
                    }
                    --i;
                }
                if (connectedComponent.size() > 0) {
                    this._stronglyConnectedComponents.add(connectedComponent);
                }
                this._stack.subList(i + 1, this._stack.size()).clear();
            }
        }
    }

    private static class NodeInfo {
        private final Node _node;
        private int _index;
        private int _lowlink;
        private boolean _onStack;

        private NodeInfo(Node n) {
            this._node = n;
            this._index = -1;
            this._lowlink = -1;
            this._onStack = false;
        }

        public String toString() {
            return this._node.toString();
        }

        public boolean isEntityNode() {
            return this._node.isEntityNode();
        }

        public <X> EntityNode<X> asEntityNode() {
            return this._node.asEntityNode();
        }
    }
}

