/*
 * Decompiled with CFR 0.152.
 */
package openllet.shared.tools;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import openllet.shared.tools.Logging;
import org.slf4j.Logger;
import org.slf4j.Marker;

public class Log
implements Logging {
    public static final java.util.logging.Logger _parent = java.util.logging.Logger.getLogger(Log.class.getName());
    public static volatile Level _defaultLevel = Level.INFO;
    public static volatile boolean _setDefaultParent = false;
    public static final Handler _systemOutHandler = new Handler(){

        @Override
        public void publish(LogRecord record) {
            StringBuffer buff = new StringBuffer();
            buff.append(record.getLevel()).append(' ');
            buff.append(record.getThreadID()).append(' ');
            buff.append(record.getLoggerName()).append(' ');
            buff.append(record.getMessage()).append(' ');
            System.out.println(buff.toString());
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    };
    private static Map<String, java.util.logging.Logger> _loggers;

    @Override
    public java.util.logging.Logger getLogger() {
        return _parent;
    }

    public void reset() {
        _loggers.clear();
    }

    private static java.util.logging.Logger config(java.util.logging.Logger logger, Level level) {
        if (_setDefaultParent) {
            logger.setParent(_parent);
        }
        _loggers.put(logger.getName(), logger);
        logger.setLevel(level);
        return logger;
    }

    public static java.util.logging.Logger getLogger(String name) {
        return Log.config(java.util.logging.Logger.getLogger(name), _defaultLevel);
    }

    public static java.util.logging.Logger getLogger(Class<?> type) {
        return Log.config(java.util.logging.Logger.getLogger(type.getSimpleName()), _defaultLevel);
    }

    public static java.util.logging.Logger getLogger(String name, Level specificLevel) {
        return Log.config(java.util.logging.Logger.getLogger(name), specificLevel);
    }

    public static java.util.logging.Logger getLogger(Class<?> type, Level specificLevel) {
        return Log.config(java.util.logging.Logger.getLogger(type.getSimpleName()), specificLevel);
    }

    public static Logger logger(String name) {
        return Log.toSlf4j(Log.config(java.util.logging.Logger.getLogger(name), _defaultLevel));
    }

    public static Logger logger(Class<?> type) {
        return Log.toSlf4j(Log.config(java.util.logging.Logger.getLogger(type.getSimpleName()), _defaultLevel));
    }

    public static Logger logger(String name, Level specificLevel) {
        return Log.toSlf4j(Log.config(java.util.logging.Logger.getLogger(name), specificLevel));
    }

    public static Logger logger(Class<?> type, Level specificLevel) {
        return Log.toSlf4j(Log.config(java.util.logging.Logger.getLogger(type.getSimpleName()), specificLevel));
    }

    public static void setLevel(java.util.logging.Logger logger, Level level) {
        logger.setLevel(level);
    }

    public static void setLevel(Level level, String filter) {
        _loggers.values().parallelStream().filter(l -> l.getName().contains(filter)).forEach(l -> l.setLevel(level));
    }

    public static void setLevel(Level level) {
        _loggers.values().parallelStream().forEach(l -> l.setLevel(level));
    }

    public static void setLevel(Level level, Class<?> type) {
        Log.setLevel(level, type.getSimpleName());
    }

    public static String error(java.util.logging.Logger logger, String msg, Function<String, Exception> pe) throws Exception {
        logger.log(Level.SEVERE, msg);
        throw pe.apply(msg);
    }

    public static void error(java.util.logging.Logger logger, Throwable e2) {
        logger.log(Level.SEVERE, "", e2);
    }

    public static void error(java.util.logging.Logger logger, String msg, Throwable e2) {
        logger.log(Level.SEVERE, msg, e2);
    }

    public static void warning(java.util.logging.Logger logger, Throwable e2) {
        logger.log(Level.WARNING, "", e2);
    }

    public static void warning(java.util.logging.Logger logger, String msg, Throwable e2) {
        logger.log(Level.WARNING, msg, e2);
    }

    public static Logger toSlf4j(final java.util.logging.Logger logger) {
        return new Logger(){

            @Override
            public String getName() {
                return logger.getName();
            }

            @Override
            public boolean isTraceEnabled() {
                return logger.isLoggable(Level.FINEST);
            }

            @Override
            public void trace(String msg) {
                logger.finest(msg);
            }

            @Override
            public void trace(String format, Object arg) {
                logger.log(Level.FINEST, format, arg);
            }

            @Override
            public void trace(String format, Object arg1, Object arg2) {
                Object[] t = new Object[]{arg1, arg2};
                logger.log(Level.FINEST, format, t);
            }

            @Override
            public void trace(String format, Object ... arguments) {
                logger.log(Level.FINEST, format, arguments);
            }

            @Override
            public void trace(String msg, Throwable t) {
                logger.log(Level.FINEST, msg, t);
            }

            @Override
            public boolean isTraceEnabled(Marker marker) {
                return this.isTraceEnabled();
            }

            @Override
            public void trace(Marker marker, String msg) {
                this.trace(msg);
            }

            @Override
            public void trace(Marker marker, String format, Object arg) {
                this.trace(format, arg);
            }

            @Override
            public void trace(Marker marker, String format, Object arg1, Object arg2) {
                this.trace(format, arg1, arg2);
            }

            @Override
            public void trace(Marker marker, String format, Object ... argArray) {
                this.trace(format, argArray);
            }

            @Override
            public void trace(Marker marker, String msg, Throwable t) {
                this.trace(msg, t);
            }

            @Override
            public boolean isDebugEnabled() {
                return logger.isLoggable(Level.FINE);
            }

            @Override
            public void debug(String msg) {
                logger.finest(msg);
            }

            @Override
            public void debug(String format, Object arg) {
                logger.log(Level.FINE, format, arg);
            }

            @Override
            public void debug(String format, Object arg1, Object arg2) {
                Object[] t = new Object[]{arg1, arg2};
                logger.log(Level.FINE, format, t);
            }

            @Override
            public void debug(String format, Object ... arguments) {
                logger.log(Level.FINE, format, arguments);
            }

            @Override
            public void debug(String msg, Throwable t) {
                logger.log(Level.FINE, msg, t);
            }

            @Override
            public boolean isDebugEnabled(Marker marker) {
                return this.isDebugEnabled();
            }

            @Override
            public void debug(Marker marker, String msg) {
                this.debug(msg);
            }

            @Override
            public void debug(Marker marker, String format, Object arg) {
                this.debug(format, arg);
            }

            @Override
            public void debug(Marker marker, String format, Object arg1, Object arg2) {
                this.debug(format, arg1, arg2);
            }

            @Override
            public void debug(Marker marker, String format, Object ... argArray) {
                this.debug(format, argArray);
            }

            @Override
            public void debug(Marker marker, String msg, Throwable t) {
                this.debug(msg, t);
            }

            @Override
            public boolean isInfoEnabled() {
                return logger.isLoggable(Level.INFO);
            }

            @Override
            public void info(String msg) {
                logger.finest(msg);
            }

            @Override
            public void info(String format, Object arg) {
                logger.log(Level.INFO, format, arg);
            }

            @Override
            public void info(String format, Object arg1, Object arg2) {
                Object[] t = new Object[]{arg1, arg2};
                logger.log(Level.INFO, format, t);
            }

            @Override
            public void info(String format, Object ... arguments) {
                logger.log(Level.INFO, format, arguments);
            }

            @Override
            public void info(String msg, Throwable t) {
                logger.log(Level.INFO, msg, t);
            }

            @Override
            public boolean isInfoEnabled(Marker marker) {
                return this.isInfoEnabled();
            }

            @Override
            public void info(Marker marker, String msg) {
                this.info(msg);
            }

            @Override
            public void info(Marker marker, String format, Object arg) {
                this.info(format, arg);
            }

            @Override
            public void info(Marker marker, String format, Object arg1, Object arg2) {
                this.info(format, arg1, arg2);
            }

            @Override
            public void info(Marker marker, String format, Object ... argArray) {
                this.info(format, argArray);
            }

            @Override
            public void info(Marker marker, String msg, Throwable t) {
                this.info(msg, t);
            }

            @Override
            public boolean isWarnEnabled() {
                return logger.isLoggable(Level.WARNING);
            }

            @Override
            public void warn(String msg) {
                logger.finest(msg);
            }

            @Override
            public void warn(String format, Object arg) {
                logger.log(Level.WARNING, format, arg);
            }

            @Override
            public void warn(String format, Object arg1, Object arg2) {
                Object[] t = new Object[]{arg1, arg2};
                logger.log(Level.WARNING, format, t);
            }

            @Override
            public void warn(String format, Object ... arguments) {
                logger.log(Level.WARNING, format, arguments);
            }

            @Override
            public void warn(String msg, Throwable t) {
                logger.log(Level.WARNING, msg, t);
            }

            @Override
            public boolean isWarnEnabled(Marker marker) {
                return this.isWarnEnabled();
            }

            @Override
            public void warn(Marker marker, String msg) {
                this.warn(msg);
            }

            @Override
            public void warn(Marker marker, String format, Object arg) {
                this.warn(format, arg);
            }

            @Override
            public void warn(Marker marker, String format, Object arg1, Object arg2) {
                this.warn(format, arg1, arg2);
            }

            @Override
            public void warn(Marker marker, String format, Object ... argArray) {
                this.warn(format, argArray);
            }

            @Override
            public void warn(Marker marker, String msg, Throwable t) {
                this.warn(msg, t);
            }

            @Override
            public boolean isErrorEnabled() {
                return logger.isLoggable(Level.SEVERE);
            }

            @Override
            public void error(String msg) {
                logger.finest(msg);
            }

            @Override
            public void error(String format, Object arg) {
                logger.log(Level.SEVERE, format, arg);
            }

            @Override
            public void error(String format, Object arg1, Object arg2) {
                Object[] t = new Object[]{arg1, arg2};
                logger.log(Level.SEVERE, format, t);
            }

            @Override
            public void error(String format, Object ... arguments) {
                logger.log(Level.FINEST, format, arguments);
            }

            @Override
            public void error(String msg, Throwable t) {
                logger.log(Level.SEVERE, msg, t);
            }

            @Override
            public boolean isErrorEnabled(Marker marker) {
                return this.isErrorEnabled();
            }

            @Override
            public void error(Marker marker, String msg) {
                this.error(msg);
            }

            @Override
            public void error(Marker marker, String format, Object arg) {
                this.error(format, arg);
            }

            @Override
            public void error(Marker marker, String format, Object arg1, Object arg2) {
                this.error(format, arg1, arg2);
            }

            @Override
            public void error(Marker marker, String format, Object ... argArray) {
                this.error(format, argArray);
            }

            @Override
            public void error(Marker marker, String msg, Throwable t) {
                this.error(msg, t);
            }
        };
    }

    static {
        String property = System.getProperty("java.util.logging.SimpleFormatter.format");
        if (null == property) {
            System.setProperty("java.util.logging.SimpleFormatter.format", "%1$tF %1$tT %4$s %2$s %5$s%6$s%n");
        }
        _parent.setLevel(_defaultLevel);
        _loggers = new ConcurrentHashMap<String, java.util.logging.Logger>();
    }
}

