/*
 * Decompiled with CFR 0.152.
 */
package openllet.shared.tools;

import java.lang.reflect.Method;
import java.util.logging.Logger;
import openllet.shared.tools.Log;

public class StackTraceInfo {
    private static final Logger _logger = Log.getLogger(StackTraceInfo.class);
    private static final int CLIENT_CODE_STACK_INDEX;
    private static Method _m;

    public static String getCurrentMethodName() {
        return _m != null ? StackTraceInfo.getCurrentMethodName_Main(1) : StackTraceInfo.getCurrentMethodName_Backup(1);
    }

    public static String getCurrentMethodName_Main(int depth) {
        try {
            StackTraceElement element = (StackTraceElement)_m.invoke((Object)new Throwable(), depth + 1);
            return element.getMethodName();
        }
        catch (Exception e2) {
            Log.error(_logger, e2);
            return "";
        }
    }

    private static String getCurrentMethodName_Backup(int offset) {
        return Thread.currentThread().getStackTrace()[CLIENT_CODE_STACK_INDEX + offset].getMethodName();
    }

    public static String getCurrentClassName() {
        return StackTraceInfo.getCurrentClassName(1);
    }

    private static String getCurrentClassName(int offset) {
        return Thread.currentThread().getStackTrace()[CLIENT_CODE_STACK_INDEX + offset].getClassName();
    }

    public static String getCurrentFileName() {
        return StackTraceInfo.getCurrentFileName(1);
    }

    private static String getCurrentFileName(int offset) {
        String filename = Thread.currentThread().getStackTrace()[CLIENT_CODE_STACK_INDEX + offset].getFileName();
        int lineNumber = Thread.currentThread().getStackTrace()[CLIENT_CODE_STACK_INDEX + offset].getLineNumber();
        return filename + ":" + lineNumber;
    }

    public static String getInvokingMethodName() {
        return StackTraceInfo.getInvokingMethodName(2);
    }

    private static String getInvokingMethodName(int offset) {
        return _m != null ? StackTraceInfo.getCurrentMethodName_Main(offset + 1) : StackTraceInfo.getCurrentMethodName_Backup(offset + 1);
    }

    public static String getInvokingClassName() {
        return StackTraceInfo.getInvokingClassName(2);
    }

    private static String getInvokingClassName(int offset) {
        return StackTraceInfo.getCurrentClassName(offset + 1);
    }

    public static String getInvokingFileName() {
        return StackTraceInfo.getInvokingFileName(2);
    }

    private static String getInvokingFileName(int offset) {
        return StackTraceInfo.getCurrentFileName(offset + 1);
    }

    public static String getCurrentMethodNameFqn() {
        return StackTraceInfo.getCurrentMethodNameFqn(1);
    }

    private static String getCurrentMethodNameFqn(int offset) {
        String currentClassName = StackTraceInfo.getCurrentClassName(offset + 1);
        String currentMethodName = _m != null ? StackTraceInfo.getCurrentMethodName_Main(offset + 1) : StackTraceInfo.getCurrentMethodName_Backup(offset + 1);
        return currentClassName + "." + currentMethodName;
    }

    public static String getCurrentFileNameFqn() {
        String CurrentMethodNameFqn = StackTraceInfo.getCurrentMethodNameFqn(1);
        String currentFileName = StackTraceInfo.getCurrentFileName(1);
        return CurrentMethodNameFqn + "(" + currentFileName + ")";
    }

    public static String getInvokingMethodNameFqn() {
        return StackTraceInfo.getInvokingMethodNameFqn(2);
    }

    private static String getInvokingMethodNameFqn(int offset) {
        String invokingClassName = StackTraceInfo.getInvokingClassName(offset + 1);
        String invokingMethodName = StackTraceInfo.getInvokingMethodName(offset + 1);
        return invokingClassName + "." + invokingMethodName;
    }

    public static String getInvokingFileNameFqn() {
        String invokingMethodNameFqn = StackTraceInfo.getInvokingMethodNameFqn(2);
        String invokingFileName = StackTraceInfo.getInvokingFileName(2);
        return invokingMethodNameFqn + "(" + invokingFileName + ")";
    }

    static {
        int i = 0;
        for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
            ++i;
            if (ste.getClassName().equals(StackTraceInfo.class.getName())) break;
        }
        CLIENT_CODE_STACK_INDEX = i;
        try {
            _m = Throwable.class.getDeclaredMethod("getStackTraceElement", Integer.TYPE);
            _m.setAccessible(true);
        }
        catch (NoSuchMethodException e2) {
            Log.error(_logger, "getCurrentMethodName() will not be available.", e2);
        }
    }
}

