/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.data;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.jena.atlas.AtlasException;
import org.apache.jena.atlas.data.DistinctDataBag;
import org.apache.jena.atlas.data.SerializationFactory;
import org.apache.jena.atlas.data.ThresholdPolicy;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.atlas.lib.FileOps;

public class DistinctDataNet<E>
extends DistinctDataBag<E> {
    protected File firstSpillFile;

    public DistinctDataNet(ThresholdPolicy<E> policy, SerializationFactory<E> serializerFactory, Comparator<E> comparator) {
        super(policy, serializerFactory, comparator);
    }

    public boolean netAdd(E item) {
        long s = this.size;
        super.add(item);
        return !this.spilled && this.size > s;
    }

    @Override
    protected void registerSpillFile(File spillFile) {
        if (!this.spilled) {
            this.firstSpillFile = spillFile;
        } else {
            super.registerSpillFile(spillFile);
        }
    }

    @Override
    protected void deleteSpillFiles() {
        super.deleteSpillFiles();
        if (this.firstSpillFile != null) {
            FileOps.delete(this.firstSpillFile, false);
            this.firstSpillFile = null;
        }
    }

    @Override
    protected List<File> getSpillFiles() {
        ArrayList<File> toReturn = new ArrayList<File>(super.getSpillFiles());
        if (this.firstSpillFile != null) {
            toReturn.add(this.firstSpillFile);
        }
        return toReturn;
    }

    protected List<File> getNetSpillFiles() {
        return super.getSpillFiles();
    }

    public Iterator<E> netIterator() {
        Iterator blacklist;
        if (!this.spilled) {
            return Iter.nullIterator();
        }
        try {
            blacklist = this.getInputIterator(this.firstSpillFile);
        }
        catch (FileNotFoundException e2) {
            throw new AtlasException("Cannot find the first spill file", e2);
        }
        Iterator rest = super.iterator();
        SortedDiffIterator sdi = SortedDiffIterator.create(rest, blacklist, this.comparator);
        this.registerCloseableIterator(sdi);
        return sdi;
    }

    protected static class SortedDiffIterator<T>
    implements Iterator<T>,
    Closeable {
        private final Iterator<T> grayList;
        private final Iterator<T> blackList;
        private final Comparator<? super T> comp;
        private boolean finished = false;
        private boolean blackSlotFull = false;
        private T white;
        private T black;

        public static <S extends Comparable<? super S>> SortedDiffIterator<S> create(Iterator<S> first, Iterator<S> second) {
            return SortedDiffIterator.create(first, second, new Comparator<S>(){

                @Override
                public int compare(S o1, S o2) {
                    if (o1 == null && o2 == null) {
                        return 0;
                    }
                    if (o1 == null) {
                        return -1;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    return o1.compareTo(o2);
                }
            });
        }

        public static <S> SortedDiffIterator<S> create(Iterator<S> first, Iterator<S> second, Comparator<? super S> comparator) {
            return new SortedDiffIterator<S>(first, second, comparator);
        }

        private SortedDiffIterator(Iterator<T> first, Iterator<T> second, Comparator<? super T> comparator) {
            this.grayList = first;
            this.blackList = second;
            this.comp = comparator;
            this.fill();
        }

        /*
         * Unable to fully structure code
         */
        private void fill() {
            if (this.finished) {
                return;
            }
            if (!this.grayList.hasNext()) {
                this.close();
                return;
            }
            if (!this.blackSlotFull) {
                if (!this.blackList.hasNext()) {
                    this.white = this.grayList.next();
                    return;
                }
                this.black = this.blackList.next();
                this.blackSlotFull = true;
            }
            while (true) {
                if (!this.grayList.hasNext()) {
                    this.close();
                    return;
                }
                this.white = this.grayList.next();
                cmp = this.comp.compare(this.white, this.black);
                if (cmp >= 0) ** GOTO lbl28
                return;
lbl-1000:
                // 1 sources

                {
                    if (!this.blackList.hasNext()) {
                        this.black = null;
                        this.blackSlotFull = false;
                        return;
                    }
                    this.black = this.blackList.next();
                    cmp = this.comp.compare(this.white, this.black);
                    if (cmp >= 0) continue;
                    return;
lbl28:
                    // 2 sources

                    ** while (cmp > 0)
                }
lbl29:
                // 1 sources

            }
        }

        @Override
        public boolean hasNext() {
            return !this.finished;
        }

        @Override
        public T next() {
            if (this.finished) {
                throw new NoSuchElementException();
            }
            T toReturn = this.white;
            this.fill();
            return toReturn;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("SortedDiffIterator.remove");
        }

        @Override
        public void close() {
            this.finished = true;
            this.white = null;
            this.black = null;
            Iter.close(this.grayList);
            Iter.close(this.blackList);
        }
    }
}

