/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.data;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import org.apache.jena.atlas.AtlasException;
import org.apache.jena.atlas.data.AbortableComparator;
import org.apache.jena.atlas.data.AbstractDataBag;
import org.apache.jena.atlas.data.SerializationFactory;
import org.apache.jena.atlas.data.ThresholdPolicy;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.IteratorResourceClosing;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.atlas.lib.Sink;

public class SortedDataBag<E>
extends AbstractDataBag<E> {
    protected static int MAX_SPILL_FILES = 100;
    protected final ThresholdPolicy<E> policy;
    protected final SerializationFactory<E> serializationFactory;
    protected final AbortableComparator<E> comparator;
    protected boolean finishedAdding = false;
    protected boolean spilled = false;
    protected boolean closed = false;

    public SortedDataBag(ThresholdPolicy<E> policy, SerializationFactory<E> serializerFactory, Comparator<? super E> comparator) {
        this.policy = policy;
        this.serializationFactory = serializerFactory;
        this.comparator = new AbortableComparator<E>(comparator);
    }

    public void cancel() {
        this.comparator.cancel();
        this.close();
    }

    public boolean isCancelled() {
        return this.comparator.cancelled;
    }

    public boolean isClosed() {
        return this.closed;
    }

    protected void checkClosed() {
        if (this.closed) {
            throw new AtlasException("SortedDataBag is closed, no operations can be performed on it.");
        }
    }

    @Override
    public boolean isSorted() {
        return true;
    }

    @Override
    public boolean isDistinct() {
        return false;
    }

    @Override
    public void add(E item) {
        this.checkClosed();
        if (this.finishedAdding) {
            throw new AtlasException("SortedDataBag: Cannot add any more items after the writing phase is complete.");
        }
        if (this.policy.isThresholdExceeded()) {
            this.spill();
        }
        if (this.memory.add(item)) {
            this.policy.increment(item);
            ++this.size;
        }
    }

    protected void spill() {
        if (this.memory.size() > 0) {
            OutputStream out;
            try {
                out = this.getSpillStream();
            }
            catch (IOException e2) {
                throw new AtlasException(e2);
            }
            Object[] array = this.memory.toArray();
            if (this.comparator.abortableSort(array) == AbortableComparator.Finish.COMPLETED) {
                try (Sink<E> serializer = this.serializationFactory.createSerializer(out);){
                    Object[] objectArray = array;
                    int n = array.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object tuple = objectArray[n2];
                        serializer.send(tuple);
                        ++n2;
                    }
                }
            }
            this.spilled = true;
            this.policy.reset();
            this.memory.clear();
        }
    }

    @Override
    public void flush() {
        this.spill();
    }

    protected Iterator<E> getInputIterator(File spillFile) throws FileNotFoundException {
        InputStream in = SortedDataBag.getInputStream(spillFile);
        Iterator<E> deserializer = this.serializationFactory.createDeserializer(in);
        return new IteratorResourceClosing<E>(deserializer, in);
    }

    @Override
    public Iterator<E> iterator() {
        this.preMerge();
        return this.iterator(this.getSpillFiles().size());
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private Iterator<E> iterator(int size) {
        this.checkClosed();
        memSize = this.memory.size();
        if (!this.finishedAdding && memSize > 1) {
            array = this.memory.toArray();
            this.comparator.abortableSort(array);
            this.memory = Arrays.asList(array);
        }
        this.finishedAdding = true;
        if (this.spilled) {
            inputs = new ArrayList<Iterator<T>>(size + (memSize > 0 ? 1 : 0));
            if (memSize > 0) {
                inputs.add(this.memory.iterator());
            }
            i = 0;
            while (i < size) {
                block8: {
                    spillFile = this.getSpillFiles().get(i);
                    try {
                        irc = this.getInputIterator(spillFile);
                        inputs.add(irc);
                        break block8;
                    }
                    catch (FileNotFoundException e) {
                        ** for (it : inputs)
                    }
lbl-1000:
                    // 1 sources

                    {
                        Iter.close(it);
                        continue;
                    }
lbl26:
                    // 1 sources

                    throw new AtlasException("Cannot find one of the spill files", e);
                }
                ++i;
            }
            ssi = new SpillSortIterator<T>(inputs, this.comparator);
            this.registerCloseableIterator(ssi);
            return ssi;
        }
        if (memSize > 0) {
            return this.memory.iterator();
        }
        return Iter.nullIterator();
    }

    /*
     * Exception decompiling
     */
    private void preMerge() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closeIterators();
            this.deleteSpillFiles();
            this.memory = null;
            this.closed = true;
        }
    }

    protected static class SpillSortIterator<T>
    implements Iterator<T>,
    Closeable {
        private final List<Iterator<T>> inputs;
        private final Comparator<? super T> comp;
        private final PriorityQueue<Item<T>> minHeap;

        public SpillSortIterator(List<Iterator<T>> inputs, Comparator<? super T> comp) {
            this.inputs = inputs;
            this.comp = comp;
            this.minHeap = new PriorityQueue(inputs.size());
            int i = 0;
            while (i < inputs.size()) {
                this.replaceItem(i);
                ++i;
            }
        }

        private void replaceItem(int index) {
            Iterator<T> it = this.inputs.get(index);
            if (it.hasNext()) {
                T tuple = it.next();
                this.minHeap.add(new Item<T>(index, tuple, this.comp));
            }
        }

        @Override
        public boolean hasNext() {
            return this.minHeap.peek() != null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Item<T> curr = this.minHeap.poll();
            this.replaceItem(curr.getIndex());
            return curr.getTuple();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("SpillSortIterator.remove");
        }

        @Override
        public void close() {
            for (Iterator<T> it : this.inputs) {
                Iter.close(it);
            }
        }

        private final class Item<U>
        implements Comparable<Item<U>> {
            private final int index;
            private final U tuple;
            private final Comparator<? super U> c;

            public Item(int index, U tuple, Comparator<? super U> c) {
                this.index = index;
                this.tuple = tuple;
                this.c = c;
            }

            public int getIndex() {
                return this.index;
            }

            public U getTuple() {
                return this.tuple;
            }

            @Override
            public int compareTo(Item<U> o) {
                return this.c != null ? this.c.compare(this.tuple, o.getTuple()) : ((Comparable)this.tuple).compareTo(o.getTuple());
            }

            public boolean equals(Object obj) {
                if (obj instanceof Item) {
                    return this.compareTo((Item)obj) == 0;
                }
                return false;
            }

            public int hashCode() {
                return this.tuple.hashCode();
            }
        }
    }
}

