/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.json;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.function.Consumer;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.json.JsonBuilder;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.atlas.json.JsonValue;
import org.apache.jena.atlas.json.io.JSONHandler;
import org.apache.jena.atlas.json.io.JSONMaker;
import org.apache.jena.atlas.json.io.JsonWriter;
import org.apache.jena.atlas.json.io.parser.JSONParser;

public class JSON {
    private static final boolean useJavaCC = false;

    public static JsonObject parse(InputStream input) {
        JSONMaker maker = new JSONMaker();
        JSON._parse(input, maker);
        return (JsonObject)maker.jsonValue();
    }

    public static JsonObject parse(String string) {
        return JSON._parse(new StringReader(string));
    }

    public static JsonValue parseAny(InputStream input) {
        JSONMaker maker = new JSONMaker();
        JSON._parseAny(input, maker);
        return maker.jsonValue();
    }

    public static JsonValue parseAny(String string) {
        return JSON._parseAny(new StringReader(string));
    }

    public static JsonObject read(String filename) {
        try {
            Throwable throwable = null;
            Object var2_5 = null;
            try (InputStream in = IO.openFileEx(filename);){
                return JSON.parse(in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException ex) {
            IO.exception("File not found: " + filename, ex);
            return null;
        }
        catch (IOException ex) {
            IO.exception("IOException: " + filename, ex);
            return null;
        }
    }

    public static JsonValue readAny(String filename) {
        try {
            Throwable throwable = null;
            Object var2_5 = null;
            try (InputStream in = IO.openFileEx(filename);){
                return JSON.parseAny(in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException("File not found: " + filename, ex);
        }
        catch (IOException ex) {
            IO.exception("IOException: " + filename, ex);
            return null;
        }
    }

    private static JsonObject _parse(Reader r) {
        JSONMaker maker = new JSONMaker();
        JSON._parse(r, maker);
        return (JsonObject)maker.jsonValue();
    }

    private static JsonValue _parseAny(Reader r) {
        JSONMaker maker = new JSONMaker();
        JSON._parseAny(r, maker);
        return maker.jsonValue();
    }

    private static void _parse(Reader r, JSONMaker maker) {
        JSONParser.parse(r, (JSONHandler)maker);
    }

    private static void _parseAny(Reader r, JSONMaker maker) {
        JSONParser.parseAny(r, (JSONHandler)maker);
    }

    private static void _parse(InputStream r, JSONMaker maker) {
        JSONParser.parse(r, (JSONHandler)maker);
    }

    private static void _parseAny(InputStream r, JSONMaker maker) {
        JSONParser.parseAny(r, (JSONHandler)maker);
    }

    public static String toString(JsonValue jValue) {
        Throwable throwable = null;
        Object var2_3 = null;
        try (IndentedLineBuffer b = new IndentedLineBuffer();){
            JSON.write(b, jValue);
            return b.asString();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String toStringFlat(JsonValue jValue) {
        Throwable throwable = null;
        Object var2_3 = null;
        try (IndentedLineBuffer b = new IndentedLineBuffer();){
            b.setFlatMode(true);
            JSON.write(b, jValue);
            return b.asString();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void write(OutputStream output, JsonValue jValue) {
        IndentedWriter iOut = new IndentedWriter(output);
        JSON.write(iOut, jValue);
        iOut.flush();
    }

    public static void write(IndentedWriter output, JsonValue jValue) {
        int rowStart = output.getRow();
        JsonWriter w = new JsonWriter(output);
        w.startOutput();
        jValue.visit(w);
        w.finishOutput();
        if (!output.inFlatMode() && output.getRow() > rowStart) {
            output.ensureStartOfLine();
        }
    }

    public static void write(JsonValue jValue) {
        JSON.write(IndentedWriter.stdout, jValue);
    }

    public static JsonValue copy(JsonValue arg) {
        return JsonBuilder.copy(arg);
    }

    public static JsonObject buildObject(Consumer<JsonBuilder> setup) {
        return JsonBuilder.buildObject(setup);
    }
}

