/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.json;

import org.apache.jena.atlas.json.JsonException;
import org.apache.jena.atlas.json.JsonValue;

public class JsonAccess {
    public static JsonValue accessPath(JsonValue obj, String ... path) {
        String[] stringArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            if (!obj.isObject()) {
                throw new JsonException("Path traverses non-object");
            }
            obj = obj.getAsObject().get(p);
            ++n2;
        }
        return obj;
    }

    public static JsonValue access(JsonValue obj, Object ... path) {
        Object[] objectArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            Object p = objectArray[n2];
            if (p instanceof String) {
                if (!obj.isObject()) {
                    throw new JsonException("Path traverses non-object");
                }
                obj = obj.getAsObject().get((String)p);
            }
            if (p instanceof Integer) {
                if (!obj.isArray()) {
                    throw new JsonException("Path traverses non-array");
                }
                obj = obj.getAsArray().get((Integer)p);
            }
            ++n2;
        }
        return obj;
    }
}

