/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.test;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.StringJoiner;
import java.util.function.IntSupplier;
import java.util.stream.IntStream;
import org.apache.jena.atlas.lib.RandomLib;

public class Gen {
    public static int[] rand(int numRand, int low, int high) {
        return Gen.rand(numRand, low, high, false);
    }

    public static int[] rand(int numRand, int low, int high, boolean allDifferent) {
        HashSet used = new HashSet();
        IntSupplier supplier = allDifferent ? () -> {
            int x = Gen.oneRandomInt(low, high);
            while (!used.add(x)) {
                x = Gen.oneRandomInt(low, high);
            }
            return x;
        } : () -> Gen.oneRandomInt(low, high);
        return IntStream.generate(supplier).limit(numRand).toArray();
    }

    private static int oneRandomInt(int low, int high) {
        return RandomLib.random.nextInt(high - low) + low;
    }

    public static int[] permute(int[] x) {
        int[] x2 = Arrays.copyOf(x, x.length);
        Collections.shuffle(Arrays.asList(new int[][]{x2}), RandomLib.random);
        return x2;
    }

    public static int[] shuffle(int[] x, int num) {
        int[] x2 = Arrays.copyOf(x, x.length);
        int i = 0;
        while (i < num) {
            int a = RandomLib.random.nextInt(x2.length);
            int b = RandomLib.random.nextInt(x2.length);
            int t = x2[a];
            x2[a] = x2[b];
            x2[b] = t;
            ++i;
        }
        return x2;
    }

    public static String strings(int[] keys) {
        StringJoiner joiner = new StringJoiner(",");
        int[] nArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            int k = nArray[n2];
            joiner.add(Integer.toString(k));
            ++n2;
        }
        return joiner.toString();
    }
}

