/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.transaction.txn;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.dboe.transaction.txn.ComponentId;
import org.apache.jena.dboe.transaction.txn.SysTransState;
import org.apache.jena.dboe.transaction.txn.Transaction;
import org.apache.jena.dboe.transaction.txn.TransactionException;
import org.apache.jena.dboe.transaction.txn.TransactionalComponent;
import org.apache.jena.dboe.transaction.txn.TxnId;
import org.apache.jena.dboe.transaction.txn.TxnState;
import org.apache.jena.query.ReadWrite;

public abstract class TransactionalComponentLifecycle<X>
implements TransactionalComponent {
    private static final boolean CHECKING = false;
    private ThreadLocal<TxnState> trackTxn = null;
    private ThreadLocal<Transaction> threadTxn = new ThreadLocal();
    private ThreadLocal<X> componentState = new ThreadLocal();
    private final ComponentId componentId;

    @Override
    public abstract void startRecovery();

    @Override
    public abstract void recover(ByteBuffer var1);

    @Override
    public abstract void finishRecovery();

    protected TransactionalComponentLifecycle(ComponentId componentId) {
        this.componentId = componentId;
    }

    @Override
    public ComponentId getComponentId() {
        return this.componentId;
    }

    @Override
    public final void begin(Transaction transaction) {
        Objects.requireNonNull(transaction);
        this.setTransaction(transaction);
        this.checkState(TxnState.INACTIVE, TxnState.COMMITTED, TxnState.ABORTED);
        this.setTrackTxn(TxnState.ACTIVE);
        X x = this._begin(transaction.getMode(), transaction.getTxnId());
        this.setDataState(x);
    }

    @Override
    public final boolean promote(Transaction transaction) {
        Objects.requireNonNull(transaction);
        this.checkState(TxnState.ACTIVE);
        X newState = this._promote(transaction.getTxnId(), this.getDataState());
        if (newState == null) {
            return false;
        }
        this.setDataState(newState);
        return true;
    }

    @Override
    public final ByteBuffer commitPrepare(Transaction transaction) {
        this.checkAligned(transaction);
        this.checkState(TxnState.ACTIVE);
        try {
            ByteBuffer byteBuffer = this._commitPrepare(transaction.getTxnId(), this.getDataState());
            return byteBuffer;
        }
        finally {
            this.setTrackTxn(TxnState.PREPARE);
        }
    }

    @Override
    public final void commit(Transaction transaction) {
        this.checkAligned(transaction);
        this.checkState(TxnState.PREPARE);
        this._commit(transaction.getTxnId(), this.getDataState());
        this.setTrackTxn(TxnState.COMMIT);
    }

    @Override
    public final void commitEnd(Transaction transaction) {
        this.checkAligned(transaction);
        this.checkState(TxnState.COMMIT);
        this._commitEnd(transaction.getTxnId(), this.getDataState());
        this.setTrackTxn(TxnState.COMMITTED);
        this.internalComplete(transaction);
    }

    @Override
    public final void abort(Transaction transaction) {
        this.checkAligned(transaction);
        this.checkState(TxnState.ACTIVE, TxnState.PREPARE, TxnState.COMMIT);
        this._abort(transaction.getTxnId(), this.getDataState());
        this.setTrackTxn(TxnState.ABORTED);
        this.internalComplete(transaction);
    }

    private void internalComplete(Transaction transaction) {
        this._complete(transaction.getTxnId(), this.getDataState());
        this.setTrackTxn(TxnState.INACTIVE);
        this.releaseThreadState();
    }

    @Override
    public final void complete(Transaction transaction) {
        if (transaction.hasFinished()) {
            return;
        }
        this.checkAligned(transaction);
        ReadWrite m = this.getReadWriteMode();
        switch (m) {
            case READ: {
                this.checkState(TxnState.ACTIVE, TxnState.COMMITTED, TxnState.ABORTED);
                break;
            }
            case WRITE: {
                this.checkState(TxnState.COMMITTED, TxnState.ABORTED);
            }
        }
        this._complete(transaction.getTxnId(), this.getDataState());
        switch (m) {
            case READ: {
                this.internalComplete(transaction);
                break;
            }
        }
    }

    @Override
    public final void shutdown() {
        this._shutdown();
        this.clearInternal();
    }

    @Override
    public final SysTransState detach() {
        TxnState txnState = this.getTxnState();
        if (txnState == null) {
            return null;
        }
        this.checkState(TxnState.ACTIVE);
        this.setTrackTxn(TxnState.DETACHED);
        SysTransState transState = new SysTransState(this, this.getTransaction(), this.getDataState());
        this.releaseThreadState();
        return transState;
    }

    @Override
    public void attach(SysTransState state) {
        Object x = state.getState();
        this.setTransaction(state.getTransaction());
        this.setDataState(x);
        this.setTrackTxn(TxnState.ACTIVE);
    }

    public ComponentState<X> getComponentState() {
        return new ComponentState<X>(this.getTrackTxn(), this.getTransaction(), this.getDataState());
    }

    public void setComponentState(ComponentState<X> state) {
        this.setTrackTxn(state.state);
        this.setTransaction(state.txn);
        this.setDataState(state.componentState);
    }

    protected void releaseThreadState() {
        if (this.trackTxn != null) {
            this.trackTxn.remove();
        }
        this.componentState.remove();
        this.threadTxn.remove();
    }

    protected void clearInternal() {
        this.trackTxn = null;
        this.threadTxn = null;
        this.componentState = null;
    }

    protected X getDataState() {
        return this.componentState.get();
    }

    protected void setDataState(X data) {
        this.componentState.set(data);
    }

    protected Transaction getTransaction() {
        return this.threadTxn.get();
    }

    protected void setTransaction(Transaction txn) {
        this.threadTxn.set(txn);
    }

    private void setTrackTxn(TxnState newState) {
    }

    private TxnState getTrackTxn() {
        return null;
    }

    protected abstract X _begin(ReadWrite var1, TxnId var2);

    protected abstract X _promote(TxnId var1, X var2);

    protected abstract ByteBuffer _commitPrepare(TxnId var1, X var2);

    protected abstract void _commit(TxnId var1, X var2);

    protected abstract void _commitEnd(TxnId var1, X var2);

    protected abstract void _abort(TxnId var1, X var2);

    protected abstract void _complete(TxnId var1, X var2);

    protected abstract void _shutdown();

    protected ReadWrite getReadWriteMode() {
        Transaction txn = this.getTransaction();
        return txn.getMode();
    }

    protected boolean isActiveTxn() {
        TxnState txnState = this.getTxnState();
        if (txnState == null) {
            return false;
        }
        switch (this.getTxnState()) {
            case INACTIVE: 
            case END_ABORTED: 
            case END_COMMITTED: {
                return false;
            }
            case ACTIVE: 
            case DETACHED: 
            case PREPARE: 
            case ABORTED: 
            case COMMIT: 
            case COMMITTED: {
                return true;
            }
        }
        throw new InternalErrorException("Unclear transaction state");
    }

    protected boolean isReadTxn() {
        return !this.isWriteTxn();
    }

    protected boolean isWriteTxn() {
        Transaction txn = this.getTransaction();
        return txn.isWriteTxn();
    }

    protected void checkTxn() {
        if (!this.isActiveTxn()) {
            throw new TransactionException("Not in a transaction");
        }
    }

    protected void checkWriteTxn() {
        Transaction txn = this.getTransaction();
        if (txn == null) {
            throw new TransactionException("Not a transaction");
        }
        txn.requireWriteTxn();
    }

    private TxnState getTxnState() {
        Transaction txn = this.getTransaction();
        if (txn == null) {
            return null;
        }
        return txn.getState();
    }

    private void checkAligned(Transaction transaction) {
    }

    private void checkState(TxnState expected) {
    }

    private void checkState(TxnState expected1, TxnState expected2) {
    }

    private void checkState(TxnState expected1, TxnState expected2, TxnState expected3) {
    }

    private static /* synthetic */ TxnState lambda$new$0() {
        return TxnState.INACTIVE;
    }

    public static class ComponentState<X> {
        final TxnState state;
        final Transaction txn;
        final X componentState;

        ComponentState(TxnState state, Transaction txn, X componentState) {
            this.state = state;
            this.txn = txn;
            this.componentState = componentState;
        }
    }
}

