/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfconnection;

import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdfconnection.RDFDatasetConnection;
import org.apache.jena.rdfconnection.SparqlQueryConnection;
import org.apache.jena.rdfconnection.SparqlUpdateConnection;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.update.UpdateRequest;

public class RDFConnectionModular
implements RDFConnection {
    private final SparqlQueryConnection queryConnection;
    private final SparqlUpdateConnection updateConnection;
    private final RDFDatasetConnection datasetConnection;
    private final Transactional transactional;

    @Override
    public void begin() {
        this.transactional.begin();
    }

    @Override
    public void begin(TxnType txnType) {
        this.transactional.begin(txnType);
    }

    @Override
    public void begin(ReadWrite mode) {
        this.transactional.begin(mode);
    }

    @Override
    public boolean promote(Transactional.Promote promote) {
        return this.transactional.promote(promote);
    }

    @Override
    public void commit() {
        this.transactional.commit();
    }

    @Override
    public void abort() {
        this.transactional.abort();
    }

    @Override
    public boolean isInTransaction() {
        return this.transactional.isInTransaction();
    }

    @Override
    public void end() {
        this.transactional.end();
    }

    @Override
    public ReadWrite transactionMode() {
        return this.transactional.transactionMode();
    }

    @Override
    public TxnType transactionType() {
        return this.transactional.transactionType();
    }

    public RDFConnectionModular(SparqlQueryConnection queryConnection, SparqlUpdateConnection updateConnection, RDFDatasetConnection datasetConnection) {
        this.queryConnection = queryConnection;
        this.updateConnection = updateConnection;
        this.datasetConnection = datasetConnection;
        this.transactional = updateConnection != null ? updateConnection : (datasetConnection != null ? datasetConnection : (queryConnection != null ? queryConnection : null));
    }

    public RDFConnectionModular(RDFConnection connection) {
        this.queryConnection = connection;
        this.updateConnection = connection;
        this.datasetConnection = connection;
        this.transactional = connection;
    }

    private SparqlQueryConnection queryConnection() {
        if (this.queryConnection == null) {
            throw new UnsupportedOperationException("No SparqlQueryConnection");
        }
        return this.queryConnection;
    }

    private SparqlUpdateConnection updateConnection() {
        if (this.updateConnection == null) {
            throw new UnsupportedOperationException("No SparqlUpdateConnection");
        }
        return this.updateConnection;
    }

    private RDFDatasetConnection datasetConnection() {
        if (this.datasetConnection == null) {
            throw new UnsupportedOperationException("No RDFDatasetConnection");
        }
        return this.datasetConnection;
    }

    @Override
    public QueryExecution query(Query query2) {
        return this.queryConnection().query(query2);
    }

    @Override
    public void update(UpdateRequest update2) {
        this.updateConnection().update(update2);
    }

    @Override
    public void load(String graphName, String file) {
        this.datasetConnection().load(graphName, file);
    }

    @Override
    public void load(String file) {
        this.datasetConnection().load(file);
    }

    @Override
    public void load(String graphName, Model model) {
        this.datasetConnection().load(graphName, model);
    }

    @Override
    public void load(Model model) {
        this.datasetConnection().load(model);
    }

    @Override
    public void put(String graphName, String file) {
        this.datasetConnection().put(graphName, file);
    }

    @Override
    public void put(String file) {
        this.datasetConnection().put(file);
    }

    @Override
    public void put(String graphName, Model model) {
        this.datasetConnection().put(graphName, model);
    }

    @Override
    public void put(Model model) {
        this.datasetConnection().put(model);
    }

    @Override
    public void delete(String graphName) {
        this.datasetConnection().delete(graphName);
    }

    @Override
    public void delete() {
        this.datasetConnection().delete();
    }

    @Override
    public void loadDataset(String file) {
        this.datasetConnection().loadDataset(file);
    }

    @Override
    public void loadDataset(Dataset dataset) {
        this.datasetConnection().loadDataset(dataset);
    }

    @Override
    public void putDataset(String file) {
        this.datasetConnection().putDataset(file);
    }

    @Override
    public void putDataset(Dataset dataset) {
        this.datasetConnection().putDataset(dataset);
    }

    @Override
    public Model fetch(String graphName) {
        return this.datasetConnection.fetch(graphName);
    }

    @Override
    public Model fetch() {
        return this.datasetConnection().fetch();
    }

    @Override
    public Dataset fetchDataset() {
        return this.datasetConnection().fetchDataset();
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public void close() {
        if (this.queryConnection != null) {
            this.queryConnection.close();
        }
        if (this.updateConnection != null) {
            this.updateConnection.close();
        }
        if (this.datasetConnection != null) {
            this.datasetConnection.close();
        }
    }
}

