/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RiotException;

public class LangBuilder {
    public String lang;
    public String officialContentType;
    public List<String> altNames = new ArrayList<String>();
    public List<String> contentTypes = new ArrayList<String>();
    public List<String> fileExtensions = new ArrayList<String>();

    public static LangBuilder create() {
        return new LangBuilder();
    }

    public static LangBuilder create(String langname, String officialContentType) {
        return new LangBuilder().langName(langname).contentType(officialContentType);
    }

    private LangBuilder() {
    }

    public LangBuilder addAltNames(String ... x) {
        LangBuilder.copy(x, this.altNames);
        return this;
    }

    public LangBuilder addAltContentTypes(String ... x) {
        LangBuilder.copy(x, this.contentTypes);
        return this;
    }

    public LangBuilder addFileExtensions(String ... x) {
        LangBuilder.copy(x, this.fileExtensions);
        return this;
    }

    private static void copy(String[] src, List<String> dst) {
        String[] stringArray = src;
        int n = src.length;
        int n2 = 0;
        while (n2 < n) {
            String str2 = stringArray[n2];
            if (!dst.contains(str2)) {
                dst.add(str2);
            }
            ++n2;
        }
    }

    public Lang build() {
        if (this.lang == null) {
            this.error("No language name");
        }
        if (this.officialContentType == null) {
            this.error("No content types");
        }
        return new Lang(this.lang, this.officialContentType, this.altNames, this.contentTypes, this.fileExtensions);
    }

    private void error(String message) {
        throw new RiotException(message);
    }

    public String getContentType() {
        return this.officialContentType;
    }

    public LangBuilder contentType(String officialContentType) {
        this.officialContentType = officialContentType;
        return this;
    }

    public LangBuilder langName(String langname) {
        this.lang = langname;
        return this;
    }
}

