/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import org.apache.http.client.HttpClient;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.graph.Graph;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFParserBuilder;
import org.apache.jena.riot.RDFParserRegistry;
import org.apache.jena.riot.ReaderRIOT;
import org.apache.jena.riot.ReaderRIOTFactory;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.RiotNotFoundException;
import org.apache.jena.riot.WebContent;
import org.apache.jena.riot.process.normalize.StreamCanonicalLangTag;
import org.apache.jena.riot.process.normalize.StreamCanonicalLiterals;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.FactoryRDF;
import org.apache.jena.riot.system.IRIResolver;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.ParserProfileStd;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.riot.system.stream.StreamManager;
import org.apache.jena.riot.web.HttpOp;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.util.Context;

public class RDFParser {
    private final String uri;
    private final Path path;
    private final String content;
    private final InputStream inputStream;
    private final Reader javaReader;
    private final StreamManager streamManager;
    private final HttpClient httpClient;
    private final Lang hintLang;
    private final Lang forceLang;
    private final String baseUri;
    private final boolean strict;
    private final boolean resolveURIs;
    private final boolean canonicalLexicalValues;
    private final LangTagForm langTagForm;
    private final Optional<Boolean> checking;
    private final IRIResolver resolver;
    private final FactoryRDF factory;
    private final ErrorHandler errorHandler;
    private final Context context;
    private boolean canUse = true;

    public static RDFParserBuilder create() {
        return RDFParserBuilder.create();
    }

    public static RDFParserBuilder source(Path path) {
        return RDFParserBuilder.create().source(path);
    }

    public static RDFParserBuilder source(String uriOrFile) {
        return RDFParserBuilder.create().source(uriOrFile);
    }

    public static RDFParserBuilder fromString(String string) {
        return RDFParserBuilder.create().fromString(string);
    }

    public static RDFParserBuilder source(InputStream input) {
        return RDFParserBuilder.create().source(input);
    }

    RDFParser(String uri, Path path, String content, InputStream inputStream, Reader javaReader, StreamManager streamManager, HttpClient httpClient, Lang hintLang, Lang forceLang, String baseUri, boolean strict, Optional<Boolean> checking, boolean canonicalLexicalValues, LangTagForm langTagForm, boolean resolveURIs, IRIResolver resolver, FactoryRDF factory, ErrorHandler errorHandler, Context context) {
        int x = this.countNonNull(uri, path, content, inputStream, javaReader);
        if (x >= 2) {
            throw new IllegalArgumentException("Only one source allowed: one of uri, path, content, inputStream and javaReader must be set");
        }
        if (x < 1) {
            throw new IllegalArgumentException("No source specified allowed: one of uri, path, content, inputStream and javaReader must be set");
        }
        Objects.requireNonNull(factory);
        Objects.requireNonNull(errorHandler);
        Objects.requireNonNull(checking);
        this.uri = uri;
        this.path = path;
        this.content = content;
        this.inputStream = inputStream;
        this.javaReader = javaReader;
        this.streamManager = streamManager;
        this.httpClient = httpClient;
        this.hintLang = hintLang;
        this.forceLang = forceLang;
        this.baseUri = baseUri;
        this.strict = strict;
        this.resolveURIs = resolveURIs;
        this.canonicalLexicalValues = canonicalLexicalValues;
        this.langTagForm = langTagForm;
        this.checking = checking;
        this.resolver = resolver;
        this.factory = factory;
        this.errorHandler = errorHandler;
        this.context = context;
    }

    private int countNonNull(Object ... objs) {
        int x = 0;
        Object[] objectArray = objs;
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj != null) {
                ++x;
            }
            ++n2;
        }
        return x;
    }

    private boolean isNonNull(Object ... objs) {
        boolean x = false;
        Object[] objectArray = objs;
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj != null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean allNull(Object ... objs) {
        boolean x = false;
        Object[] objectArray = objs;
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj != null) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void parse(Graph graph) {
        this.parse(StreamRDFLib.graph(graph));
    }

    public void parse(Model model) {
        this.parse(model.getGraph());
    }

    public void parse(DatasetGraph dataset) {
        this.parse(StreamRDFLib.dataset(dataset));
    }

    public void parse(Dataset dataset) {
        this.parse(dataset.asDatasetGraph());
    }

    public void parse(StreamRDF destination) {
        if (!this.canUse) {
            throw new RiotException("Parser has been used once and can not be used again");
        }
        this.canUse = this.inputStream == null && this.javaReader == null;
        this.factory.reset();
        if (this.canonicalLexicalValues) {
            destination = new StreamCanonicalLiterals(destination);
        }
        switch (this.langTagForm) {
            case NONE: {
                break;
            }
            case CANONICAL: {
                destination = StreamCanonicalLangTag.toCanonical(destination);
                break;
            }
            case LOWER_CASE: {
                destination = StreamCanonicalLangTag.toLC(destination);
                break;
            }
            default: {
                throw new InternalErrorException("langTagForm = " + (Object)((Object)this.langTagForm));
            }
        }
        if (this.isNonNull(this.content, this.inputStream, this.javaReader)) {
            this.parseNotUri(destination);
            return;
        }
        Objects.requireNonNull(this.baseUri);
        this.parseURI(destination);
    }

    private void parseURI(StreamRDF destination) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (TypedInputStream input = this.openTypedInputStream(this.uri, this.path);){
            ReaderRIOT reader;
            ContentType ct;
            if (this.forceLang != null) {
                ReaderRIOTFactory r = RDFParserRegistry.getFactory(this.forceLang);
                if (r == null) {
                    throw new RiotException("No parser registered for language: " + this.forceLang);
                }
                ct = this.forceLang.getContentType();
                reader = this.createReader(r, this.forceLang);
            } else {
                ct = WebContent.determineCT(input.getContentType(), this.hintLang, this.baseUri);
                if (ct == null) {
                    throw new RiotException("Failed to determine the content type: (URI=" + this.baseUri + " : stream=" + input.getContentType() + ")");
                }
                reader = this.createReader(ct);
                if (reader == null) {
                    throw new RiotException("No parser registered for content type: " + ct.getContentType());
                }
            }
            RDFParser.read(reader, input, null, this.baseUri, this.context, ct, destination);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void parseNotUri(StreamRDF destination) {
        ContentType ct;
        Lang lang = this.hintLang;
        if (this.forceLang != null) {
            lang = this.forceLang;
        }
        if ((ct = WebContent.determineCT(null, lang, this.baseUri)) == null) {
            throw new RiotException("Failed to determine the RDF syntax (.lang or .base required)");
        }
        ReaderRIOT readerRiot = this.createReader(ct);
        if (readerRiot == null) {
            throw new RiotException("No parser registered for content type: " + ct.getContentType());
        }
        Reader jr = this.javaReader;
        if (this.content != null) {
            jr = new StringReader(this.content);
        }
        RDFParser.read(readerRiot, this.inputStream, jr, this.baseUri, this.context, ct, destination);
    }

    private static void read(ReaderRIOT readerRiot, InputStream inputStream, Reader javaReader, String baseUri, Context context, ContentType ct, StreamRDF destination) {
        if (inputStream != null && javaReader != null) {
            throw new InternalErrorException("Both inputStream and javaReader are non-null");
        }
        if (inputStream != null) {
            readerRiot.read(inputStream, baseUri, ct, destination, context);
            return;
        }
        if (javaReader != null) {
            readerRiot.read(javaReader, baseUri, ct, destination, context);
            return;
        }
        throw new InternalErrorException("Both inputStream and javaReader are null");
    }

    private TypedInputStream openTypedInputStream(String urlStr, Path path) {
        TypedInputStream in;
        if (path != null) {
            try {
                InputStream in2 = Files.newInputStream(path, new OpenOption[0]);
                ContentType ct = RDFLanguages.guessContentType(urlStr);
                return new TypedInputStream(in2, ct);
            }
            catch (FileNotFoundException | NoSuchFileException ex) {
                throw new RiotNotFoundException();
            }
            catch (IOException ex) {
                IO.exception(ex);
            }
        }
        if ((urlStr = StreamManager.get(this.context).mapURI(urlStr)).startsWith("http://") || urlStr.startsWith("https://")) {
            String acceptHeader = this.httpClient == null ? "text/turtle,application/n-triples;q=0.9,application/rdf+xml;q=0.7,application/trig,application/n-quads;q=0.9,text/x-nquads;q=0.8,application/x-trig;q=0.7,application/ld+json;q=0.6,*/*;q=0.5" : null;
            in = HttpOp.execHttpGet(urlStr, acceptHeader, this.httpClient, null);
        } else {
            in = this.streamManager.open(urlStr);
        }
        if (in == null) {
            throw new RiotNotFoundException("Not found: " + urlStr);
        }
        return in;
    }

    private ReaderRIOT createReader(ContentType ct) {
        Lang lang = RDFLanguages.contentTypeToLang(ct);
        if (lang == null) {
            return null;
        }
        ReaderRIOTFactory r = RDFParserRegistry.getFactory(lang);
        if (r == null) {
            return null;
        }
        ReaderRIOT reader = this.createReader(r, lang);
        return reader;
    }

    private ReaderRIOT createReader(ReaderRIOTFactory r, Lang lang) {
        ParserProfile profile = this.makeParserProfile(lang);
        ReaderRIOT reader = r.create(lang, profile);
        return reader;
    }

    private ParserProfile makeParserProfile(Lang lang) {
        IRIResolver resolver;
        boolean resolve = this.resolveURIs;
        boolean checking$ = this.strict;
        if (RDFLanguages.sameLang(RDFLanguages.NTRIPLES, lang) || RDFLanguages.sameLang(RDFLanguages.NQUADS, lang)) {
            if (!this.strict) {
                checking$ = this.checking.orElseGet(() -> false);
            }
            resolve = false;
        } else if (!this.strict) {
            checking$ = this.checking.orElseGet(() -> true);
        }
        if (RDFLanguages.sameLang(RDFLanguages.RDFJSON, lang)) {
            resolve = false;
        }
        if ((resolver = this.resolver) == null) {
            resolver = resolve ? IRIResolver.create(this.baseUri) : IRIResolver.createNoResolve();
        }
        PrefixMap prefixMap = PrefixMapFactory.createForInput();
        ParserProfileStd parserFactory = new ParserProfileStd(this.factory, this.errorHandler, resolver, prefixMap, this.context, checking$, this.strict);
        return parserFactory;
    }

    static enum LangTagForm {
        NONE,
        LOWER_CASE,
        CANONICAL;

    }
}

