/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.graph.Graph;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFWriterBuilder;
import org.apache.jena.riot.RDFWriterRegistry;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.WriterDatasetRIOT;
import org.apache.jena.riot.WriterDatasetRIOTFactory;
import org.apache.jena.riot.WriterGraphRIOT;
import org.apache.jena.riot.WriterGraphRIOTFactory;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.util.Context;

public class RDFWriter {
    private static int BUF_SIZE = 131072;
    private final DatasetGraph dataset;
    private final Graph graph;
    private final RDFFormat format;
    private final String baseURI;
    private final Context context;

    public static RDFWriterBuilder create() {
        return new RDFWriterBuilder();
    }

    RDFWriter(DatasetGraph dataset, Graph graph, RDFFormat format, Lang lang, String baseURI, Context context) {
        this.dataset = dataset;
        this.graph = graph;
        this.format = RDFWriter.chooseFormat(format, lang);
        this.baseURI = baseURI;
        this.context = context;
    }

    private static RDFFormat chooseFormat(RDFFormat format, Lang lang) {
        if (format != null) {
            return format;
        }
        if (lang == null) {
            return null;
        }
        format = RDFWriterRegistry.defaultSerialization(lang);
        return format;
    }

    public String asString() {
        if (this.format == null) {
            throw new RiotException("Output as a string needs the Lang/Format specificied");
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (StringWriter sw = new StringWriter();){
                this.output(sw, this.format);
                return sw.toString();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            IO.exception(ex);
            return null;
        }
    }

    public void output(OutputStream output) {
        this.output(output, this.format);
    }

    @Deprecated
    public void output(Writer javaWriter) {
        this.output(javaWriter, this.format);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void output(String filename) {
        Object lang;
        Objects.requireNonNull(filename, "Null filename");
        RDFFormat fmt = this.format;
        if (fmt == null) {
            ContentType ct = RDFLanguages.guessContentType(filename);
            if (ct == null) {
                throw new RiotException("Lang and RDFformat unset and can't determine syntax from '" + filename + "'");
            }
            lang = RDFLanguages.contentTypeToLang(ct);
            if (lang == null) {
                throw new RiotException("No syntax registered for '" + ct.getContentType() + "'");
            }
            fmt = RDFWriterRegistry.defaultSerialization((Lang)lang);
        }
        if (filename.equals("-")) {
            this.output(System.out, fmt);
            return;
        }
        Path p = Paths.get(filename, new String[0]);
        try {
            lang = null;
            Object var5_7 = null;
            try {
                OutputStream out1 = Files.newOutputStream(p, new OpenOption[0]);
                try {
                    try (BufferedOutputStream out = new BufferedOutputStream(out1, BUF_SIZE);){
                        this.output(out, fmt);
                    }
                    if (out1 == null) return;
                }
                catch (Throwable throwable) {
                    if (lang == null) {
                        lang = throwable;
                    } else if (lang != throwable) {
                        ((Throwable)lang).addSuppressed(throwable);
                    }
                    if (out1 == null) throw lang;
                    out1.close();
                    throw lang;
                }
                out1.close();
                return;
            }
            catch (Throwable throwable) {
                if (lang == null) {
                    lang = throwable;
                    throw lang;
                } else {
                    if (lang == throwable) throw lang;
                    ((Throwable)lang).addSuppressed(throwable);
                }
                throw lang;
            }
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    private void output(OutputStream output, RDFFormat format) {
        if (format == null) {
            throw new RiotException("No syntax (Lang or RDFFormat) for output");
        }
        if (this.graph != null) {
            this.write$(output, this.graph, format);
            return;
        }
        if (this.dataset != null) {
            this.write$(output, this.dataset, format);
            return;
        }
        throw new RiotException("No graph or dataset to write");
    }

    private void output(Writer javaWriter, RDFFormat format) {
        if (format == null) {
            throw new RiotException("No syntax (Lang or RDFFormat) for output");
        }
        if (this.graph != null) {
            this.write$(javaWriter, this.graph, format);
            return;
        }
        if (this.dataset != null) {
            this.write$(javaWriter, this.dataset, format);
            return;
        }
        throw new RiotException("No graph or dataset to write");
    }

    private static WriterGraphRIOT createGraphWriter$(RDFFormat serialization) {
        WriterGraphRIOTFactory wf = RDFWriterRegistry.getWriterGraphFactory(serialization);
        if (wf == null) {
            throw new RiotException("No graph writer for " + serialization);
        }
        return wf.create(serialization);
    }

    private static WriterDatasetRIOT createDatasetWriter$(RDFFormat serialization) {
        WriterDatasetRIOTFactory wf = RDFWriterRegistry.getWriterDatasetFactory(serialization);
        if (wf == null) {
            throw new RiotException("No dataset writer for " + serialization);
        }
        return wf.create(serialization);
    }

    private void write$(OutputStream out, Graph graph, RDFFormat serialization) {
        WriterGraphRIOT w = RDFWriter.createGraphWriter$(serialization);
        w.write(out, graph, RiotLib.prefixMap(graph), this.baseURI, this.context);
    }

    private void write$(OutputStream out, DatasetGraph dataset, RDFFormat serialization) {
        WriterDatasetRIOT w = RDFWriter.createDatasetWriter$(serialization);
        w.write(out, dataset, RiotLib.prefixMap(dataset), this.baseURI, this.context);
    }

    private void write$(Writer out, Graph graph, RDFFormat serialization) {
        WriterGraphRIOT w = RDFWriter.createGraphWriter$(serialization);
        w.write(out, graph, RiotLib.prefixMap(graph), this.baseURI, this.context);
    }

    private void write$(Writer out, DatasetGraph dataset, RDFFormat serialization) {
        WriterDatasetRIOT w = RDFWriter.createDatasetWriter$(serialization);
        w.write(out, dataset, RiotLib.prefixMap(dataset), this.baseURI, this.context);
    }
}

