/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import org.apache.jena.graph.Node;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.lang.LangTurtleBase;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.tokens.Token;
import org.apache.jena.riot.tokens.TokenType;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.sparql.core.Quad;

public class LangTriG
extends LangTurtleBase {
    public LangTriG(Tokenizer tokens2, ParserProfile profile, StreamRDF dest) {
        super(tokens2, profile, dest);
    }

    @Override
    public Lang getLang() {
        return RDFLanguages.TRIG;
    }

    @Override
    protected final void oneTopLevelElement() {
        this.oneNamedGraphBlock2();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void oneNamedGraphBlock2() {
        boolean mustBeNamedGraph;
        Token t;
        Node graphNode;
        block16: {
            Token token;
            graphNode = null;
            t = token = this.peekToken();
            mustBeNamedGraph = false;
            if (this.lookingAt(TokenType.KEYWORD)) {
                if (token.getImage().equalsIgnoreCase("GRAPH")) {
                    this.nextToken();
                    mustBeNamedGraph = true;
                    token = this.peekToken();
                } else {
                    this.exception(t, "Keyword '" + token.getImage() + "' not allowed here", new Object[0]);
                }
            }
            if (this.lookingAt(TokenType.LBRACKET)) {
                this.nextToken();
                token = this.peekToken();
                Node blank = this.profile.createBlankNode(graphNode, t.getLine(), t.getColumn());
                if (this.lookingAt(TokenType.RBRACKET)) {
                    this.nextToken();
                    if (this.lookingAt(TokenType.LBRACE)) {
                        graphNode = blank;
                        break block16;
                    } else {
                        if (mustBeNamedGraph) {
                            this.exception(t, "Keyword 'GRAPH' must start a named graph", new Object[0]);
                        }
                        this.turtle(blank);
                        return;
                    }
                }
                if (mustBeNamedGraph) {
                    this.exception(t, "Keyword 'GRAPH' must start a named graph", new Object[0]);
                }
                this.triplesBlankNode(blank);
                if (this.peekPredicate()) {
                    this.predicateObjectList(blank);
                }
                this.expectEndOfTriplesTurtle();
                return;
            }
            if (token.isNode()) {
                Node n = this.node();
                this.nextToken();
                token = this.peekToken();
                if (this.lookingAt(TokenType.LBRACE)) {
                    graphNode = n;
                    break block16;
                } else {
                    if (mustBeNamedGraph) {
                        this.exception(t, "Keyword 'GRAPH' must start a named graph", new Object[0]);
                    }
                    this.turtle(n);
                    return;
                }
            }
            if (this.lookingAt(TokenType.LPAREN)) {
                this.turtle();
                return;
            }
        }
        if (mustBeNamedGraph && graphNode == null) {
            this.exception(t, "Keyword 'GRAPH' must be followed by a graph name", new Object[0]);
        }
        this.bracedGraph(t, graphNode);
    }

    protected final void turtle(Node n) {
        this.predicateObjectList(n);
        this.expectEndOfTriplesTurtle();
    }

    protected final void turtle() {
        this.triplesSameSubject();
    }

    protected final void oneNamedGraphBlock() {
        Token token;
        Node graphNode = null;
        Token t = token = this.peekToken();
        if (this.lookingAt(TokenType.LBRACKET)) {
            this.nextToken();
            token = this.peekToken();
            if (this.lookingAt(TokenType.RBRACKET)) {
                this.exception(t, "Broken term: [ not followed by ]", new Object[0]);
            }
            graphNode = this.profile.createBlankNode(graphNode, t.getLine(), t.getColumn());
            this.nextToken();
        } else if (token.isNode()) {
            graphNode = this.node();
            this.nextToken();
        }
        this.bracedGraph(t, graphNode);
    }

    private void bracedGraph(Token t, Node graphNode) {
        if (graphNode != null) {
            if (graphNode.isURI() || graphNode.isBlank()) {
                this.setCurrentGraph(graphNode);
            } else {
                this.exception(t, "Not a legal graph name: " + graphNode, new Object[0]);
            }
        } else {
            this.setCurrentGraph(Quad.tripleInQuad);
        }
        Token token = this.peekToken();
        if (this.lookingAt(TokenType.EQUALS)) {
            if (this.isStrictMode) {
                this.exception(token, "Use of = {} is not part of standard TriG: " + graphNode, new Object[0]);
            }
            this.nextToken();
            token = this.peekToken();
        }
        if (!this.lookingAt(TokenType.LBRACE)) {
            this.exception(token, "Expected start of graph: got %s", this.peekToken());
        }
        this.nextToken();
        while (true) {
            token = this.peekToken();
            if (this.lookingAt(TokenType.RBRACE)) break;
            this.triplesSameSubject();
        }
        token = this.nextToken();
        if (this.lookingAt(TokenType.RBRACE)) {
            this.exception(token, "Expected end of graph: got %s", token);
        }
        if (!this.isStrictMode) {
            token = this.peekToken();
            if (this.lookingAt(TokenType.DOT)) {
                this.nextToken();
            }
        }
        this.setCurrentGraph(Quad.tripleInQuad);
    }

    @Override
    protected void expectEndOfTriples() {
        this.expectEndOfTriplesBraceGraph();
    }

    protected void expectEndOfTriplesBraceGraph() {
        if (this.lookingAt(TokenType.DOT)) {
            this.nextToken();
            return;
        }
        if (this.lookingAt(TokenType.RBRACE)) {
            return;
        }
        this.exception(this.peekToken(), "Triples not terminated properly: expected '.', '}' or EOF: got %s", this.peekToken());
    }

    @Override
    protected void emit(Node subject, Node predicate, Node object) {
        Node graph = this.getCurrentGraph();
        if (graph == Quad.defaultGraphNodeGenerated) {
            graph = Quad.tripleInQuad;
        }
        Quad quad = this.profile.createQuad(graph, subject, predicate, object, this.currLine, this.currCol);
        this.dest.quad(quad);
    }
}

