/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.out;

import java.net.MalformedURLException;
import java.util.Map;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.Bytes;
import org.apache.jena.atlas.lib.Chars;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.iri.IRI;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.riot.out.NodeFormatterNT;
import org.apache.jena.riot.out.NodeFormatterTTL;
import org.apache.jena.riot.system.IRIResolver;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.system.Prologue;
import org.apache.jena.riot.system.RiotChars;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.core.Quad;

public class NodeFmtLib {
    private static final NodeFormatter plainFormatter = new NodeFormatterNT();
    private static PrefixMap dftPrefixMap = PrefixMapFactory.create();
    static char encodeMarkerChar;
    private static char LabelLeadingLetter;
    private static int relFlags;

    static {
        PrefixMapping pm = ARQConstants.getGlobalPrefixMap();
        Map<String, String> map = pm.getNsPrefixMap();
        for (Map.Entry<String, String> e2 : map.entrySet()) {
            dftPrefixMap.add(e2.getKey(), e2.getValue());
        }
        encodeMarkerChar = (char)88;
        LabelLeadingLetter = (char)66;
        relFlags = 9;
    }

    public static String str(Triple t) {
        return NodeFmtLib.strNodes(t.getSubject(), t.getPredicate(), t.getObject());
    }

    public static String str(Quad q) {
        return NodeFmtLib.strNodes(q.getGraph(), q.getSubject(), q.getPredicate(), q.getObject());
    }

    public static String str(Node n) {
        IndentedLineBuffer sw = new IndentedLineBuffer();
        NodeFmtLib.str(sw, n);
        return sw.toString();
    }

    public static String displayStr(RDFNode obj) {
        return NodeFmtLib.displayStr(obj.asNode());
    }

    public static String displayStr(Node n) {
        return NodeFmtLib.str(n, null, dftPrefixMap);
    }

    public static String strNodes(Node ... nodes) {
        IndentedLineBuffer sw = new IndentedLineBuffer();
        boolean first = true;
        Node[] nodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node n3 = nodeArray[n2];
            if (!first) {
                sw.append(" ", new Object[0]);
            }
            first = false;
            NodeFmtLib.str(sw, n3);
            ++n2;
        }
        return sw.toString();
    }

    public static void str(IndentedWriter w, Node n) {
        NodeFmtLib.serialize(w, n, null, null);
    }

    public static String str(Node n, Prologue prologue) {
        return NodeFmtLib.str(n, prologue.getBaseURI(), prologue.getPrefixMap());
    }

    public static String str(Node n, String base, PrefixMap prefixMap) {
        IndentedLineBuffer sw = new IndentedLineBuffer();
        NodeFmtLib.serialize(sw, n, base, prefixMap);
        return sw.toString();
    }

    public static void serialize(IndentedWriter w, Node n, Prologue prologue) {
        NodeFmtLib.serialize(w, n, prologue.getBaseURI(), prologue.getPrefixMap());
    }

    public static void serialize(IndentedWriter w, Node n, String base, PrefixMap prefixMap) {
        NodeFormatter formatter = base == null && prefixMap == null ? plainFormatter : new NodeFormatterTTL(base, prefixMap);
        formatter.format(w, n);
    }

    public static String encodeBNodeLabel(String label) {
        StringBuilder buff = new StringBuilder();
        buff.append(LabelLeadingLetter);
        int i = 0;
        while (i < label.length()) {
            char ch = label.charAt(i);
            if (ch == encodeMarkerChar) {
                buff.append(ch);
                buff.append(ch);
            } else if (RiotChars.isA2ZN(ch)) {
                buff.append(ch);
            } else {
                Chars.encodeAsHex(buff, encodeMarkerChar, ch);
            }
            ++i;
        }
        return buff.toString();
    }

    public static String decodeBNodeLabel(String label) {
        StringBuilder buffer = new StringBuilder();
        if (label.charAt(0) != LabelLeadingLetter) {
            return label;
        }
        int i = 1;
        while (i < label.length()) {
            char ch = label.charAt(i);
            if (ch != encodeMarkerChar) {
                buffer.append(ch);
            } else {
                char ch2 = label.charAt(i + 1);
                if (ch2 == encodeMarkerChar) {
                    ++i;
                    buffer.append(ch);
                } else {
                    char hiC = label.charAt(++i);
                    int hi = Bytes.hexCharToInt(hiC);
                    char loC = label.charAt(++i);
                    int lo = Bytes.hexCharToInt(loC);
                    int combined = hi << 4 | lo;
                    buffer.append((char)combined);
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String abbrevByBase(String uri, String base) {
        if (base == null) {
            return null;
        }
        IRI baseIRI = IRIResolver.iriFactory().construct(base);
        IRI rel = baseIRI.relativize(uri, relFlags);
        String r = null;
        try {
            r = rel.toASCIIString();
        }
        catch (MalformedURLException ex) {
            r = rel.toString();
        }
        return r;
    }
}

