/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.out;

import java.io.OutputStream;
import java.util.Objects;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.atlas.lib.Sink;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.util.FmtUtils;

public class SinkQuadBracedOutput
implements Sink<Quad>,
Closeable {
    protected static final int BLOCK_INDENT = 2;
    protected final IndentedWriter out;
    protected final SerializationContext sCxt;
    protected boolean opened = false;
    protected Node currentGraph;

    public SinkQuadBracedOutput(OutputStream out) {
        this(out, null);
    }

    public SinkQuadBracedOutput(OutputStream out, SerializationContext sCxt) {
        this(new IndentedWriter(out), sCxt);
    }

    public SinkQuadBracedOutput(IndentedWriter out, SerializationContext sCxt) {
        if (out == null) {
            throw new IllegalArgumentException("out may not be null");
        }
        if (sCxt == null) {
            sCxt = new SerializationContext();
        }
        this.out = out;
        this.sCxt = sCxt;
    }

    public void open() {
        this.out.println("{");
        this.out.incIndent(2);
        this.opened = true;
    }

    private void checkOpen() {
        if (!this.opened) {
            throw new IllegalStateException("SinkQuadBracedOutput is not opened.  Call open() first.");
        }
    }

    @Override
    public void send(Quad quad) {
        this.send(quad.getGraph(), quad.asTriple());
    }

    public void send(Node graphName, Triple triple) {
        this.checkOpen();
        if (Quad.isDefaultGraph(graphName)) {
            graphName = null;
        }
        if (!Objects.equals(this.currentGraph, graphName)) {
            if (this.currentGraph != null) {
                this.out.decIndent(2);
                this.out.println("}");
            }
            if (graphName != null) {
                this.out.print("GRAPH ");
                this.output(graphName);
                this.out.println(" {");
                this.out.incIndent(2);
            }
        }
        this.output(triple);
        this.out.println(" .");
        this.currentGraph = graphName;
    }

    private void output(Node node) {
        String n = FmtUtils.stringForNode(node, this.sCxt);
        this.out.print(n);
    }

    private void output(Triple triple) {
        String ts = FmtUtils.stringForTriple(triple, this.sCxt);
        this.out.print(ts);
    }

    @Override
    public void flush() {
        this.out.flush();
    }

    @Override
    public void close() {
        if (this.opened) {
            if (this.currentGraph != null) {
                this.out.decIndent(2);
                this.out.println("}");
            }
            this.out.decIndent(2);
            this.out.print("}");
            this.flush();
            this.opened = false;
        }
    }
}

