/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.process.normalize;

import org.apache.jena.graph.NodeFactory;
import org.apache.jena.riot.process.normalize.DatatypeHandler;

class NormalizeValue2 {
    static char NonChar = '\u0000';
    static char CH_ZERO = (char)48;
    static DatatypeHandler dtInteger = (node, lexicalForm, datatype) -> {
        char[] chars = lexicalForm.toCharArray();
        if (chars.length == 0) {
            return node;
        }
        NormalizeValue2.stripLeadingPlus(chars);
        NormalizeValue2.stripLeadingZeros(chars);
        String lex2 = NormalizeValue2.rebuild(chars);
        if (lex2 == null) {
            return node;
        }
        return NodeFactory.createLiteral(lex2, datatype);
    };
    static DatatypeHandler dtDecimal = (node, lexicalForm, datatype) -> {
        char[] chars = lexicalForm.toCharArray();
        if (chars.length == 0) {
            return node;
        }
        NormalizeValue2.stripLeadingPlus(chars);
        NormalizeValue2.stripLeadingZeros(chars);
        NormalizeValue2.stripTrailingZeros(chars);
        String lex2 = NormalizeValue2.rebuild(chars);
        if (lex2 == null) {
            return node;
        }
        return NodeFactory.createLiteral(lex2, datatype);
    };

    NormalizeValue2() {
    }

    private static void stripLeadingPlus(char[] chars) {
        if (chars[0] == '+') {
            chars[0] = NonChar;
        }
    }

    private static void stripLeadingZeros(char[] chars) {
        int idx = 0;
        if (chars[0] == '-' || chars[0] == NonChar) {
            idx = 1;
        }
        while (idx < chars.length && chars[idx] == CH_ZERO) {
            chars[idx] = NonChar;
            ++idx;
        }
        if (idx == chars.length || chars[idx] == '.') {
            chars[idx - 1] = CH_ZERO;
        }
    }

    private static void stripTrailingZeros(char[] chars) {
        int iDot = 0;
        while (iDot < chars.length) {
            if (chars[iDot] == '.') break;
            ++iDot;
        }
        int cfr_ignored_0 = chars.length;
        int start = 0;
        if (chars[0] == '-' || chars[0] == NonChar) {
            start = 1;
        }
        int idx = chars.length - 1;
        while (idx >= start) {
            if (chars[idx] != CH_ZERO) break;
            chars[idx] = NonChar;
            --idx;
        }
        if (idx == start || chars[idx] == '.') {
            chars[idx - 1] = CH_ZERO;
        }
    }

    private static String rebuild(char[] chars) {
        boolean modified = false;
        int j = 0;
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == NonChar) {
                modified = true;
            } else if (modified) {
                chars[j] = chars[i];
                ++j;
            }
            ++i;
        }
        if (!modified) {
            return null;
        }
        return new String(chars, 0, j);
    }
}

