/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.resultset.rw;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.query.ResultSet;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.resultset.ResultSetWriter;
import org.apache.jena.riot.resultset.ResultSetWriterFactory;
import org.apache.jena.riot.resultset.ResultSetWriterRegistry;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sys.JenaSystem;

public class ResultsWriter {
    private final Lang lang;
    private final Context context;

    static {
        JenaSystem.init();
    }

    public static Builder create() {
        return new Builder();
    }

    private ResultsWriter(Lang lang, Context context) {
        this.lang = lang;
        this.context = context;
    }

    public void write(String filename, ResultSet resultSet) {
        Objects.requireNonNull(filename);
        Objects.requireNonNull(resultSet);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (OutputStream out = this.openURL(filename);){
                this.write(out, resultSet);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    public void write(OutputStream output, ResultSet resultSet) {
        Objects.requireNonNull(output);
        Objects.requireNonNull(resultSet);
        this.write(output, resultSet, null, this.lang);
    }

    public void write(String filename, boolean booleanResult) {
        Objects.requireNonNull(filename);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (OutputStream out = this.openURL(filename);){
                this.write(out, booleanResult);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    public void write(OutputStream output, boolean booleanResult) {
        Objects.requireNonNull(output);
        this.write(output, null, booleanResult, this.lang);
    }

    private void write(OutputStream output, ResultSet resultSet, Boolean result, Lang lang) {
        if (resultSet == null && result == null) {
            throw new RiotException("No result set and no boolean result");
        }
        if (resultSet != null && result != null) {
            throw new RiotException("Both result set and boolean result supplied");
        }
        if (!ResultSetWriterRegistry.isRegistered(lang)) {
            throw new RiotException("Not registered as a SPARQL result set output syntax: " + lang);
        }
        ResultSetWriterFactory factory = ResultSetWriterRegistry.getFactory(lang);
        if (factory == null) {
            throw new RiotException("No ResultSetReaderFactory for " + lang);
        }
        ResultSetWriter writer = factory.create(lang);
        if (resultSet != null) {
            writer.write(output, resultSet, this.context);
        } else {
            writer.write(output, result, this.context);
        }
    }

    private OutputStream openURL(String filename) {
        return IO.openOutputFile(filename);
    }

    /* synthetic */ ResultsWriter(Lang lang, Context context, ResultsWriter resultsWriter) {
        this(lang, context);
    }

    public static class Builder {
        private Lang lang = null;
        private Context context = null;

        public Builder lang(Lang lang) {
            this.lang = lang;
            return this;
        }

        public Builder context(Context context) {
            if (context != null) {
                context = context.copy();
            }
            this.context = context;
            return this;
        }

        public ResultsWriter build() {
            return new ResultsWriter(this.lang, this.context, null);
        }

        public void write(String url, ResultSet resultSet) {
            this.build().write(url, resultSet);
        }

        public void write(OutputStream output, ResultSet resultSet) {
            this.build().write(output, resultSet);
        }
    }
}

