/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.atlas.lib.NotImplemented;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.system.IteratorStreamRDF;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.system.StreamRowRDF;
import org.apache.jena.riot.tokens.Token;
import org.apache.jena.riot.tokens.TokenType;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.riot.tokens.TokenizerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IteratorStreamRDFText
extends IteratorStreamRDF
implements Iterator<StreamRowRDF> {
    private final TokenInputStream in;
    private Node[] previousTuple = null;

    private IteratorStreamRDFText(InputStream input) {
        Tokenizer t = TokenizerFactory.makeTokenizerUTF8(input);
        this.in = new TokenInputStream(null, t);
    }

    @Override
    protected boolean hasMore() {
        return true;
    }

    @Override
    protected StreamRowRDF moveToNext() {
        if (!this.in.hasNext()) {
            return null;
        }
        Object line = this.in.next();
        StreamRowRDF row = this.line2row((List<Token>)line);
        return row;
    }

    private StreamRowRDF line2row(List<Token> line) {
        if (line.size() != 3 && line.size() != 4) {
            throw new RiotException("Input line is not 3 or 4 items long");
        }
        Node[] tuple = new Node[line.size()];
        int idx = 0;
        for (Token token : line) {
            Node n = null;
            if (token.isWord() && token.getImage().equals("R")) {
                if (this.previousTuple == null) {
                    throw new RiotException("Repeat without previous data row");
                }
                if (idx >= this.previousTuple.length) {
                    throw new RiotException("Repeat position beyond previous data row");
                }
                n = this.previousTuple[idx];
            } else if (token.isNode()) {
                n = IteratorStreamRDFText.asNode(token);
            }
            if (n == null) {
                throw new RiotException("Unrecognized token : " + token);
            }
            tuple[idx] = n;
            ++idx;
        }
        this.previousTuple = tuple;
        throw new NotImplemented();
    }

    private static Node asNode(Token t) {
        if (t.isIRI()) {
            return RiotLib.createIRIorBNode(t.getImage());
        }
        return t.asNode();
    }

    private static class TokenInputStream
    implements Iterator<List<Token>>,
    Iterable<List<Token>>,
    Closeable {
        private static Logger log = LoggerFactory.getLogger(TokenInputStream.class);
        private boolean finished = false;
        private final Tokenizer tokens;
        private List<Token> list;
        private Map<String, String> map = new HashMap<String, String>();
        private String label;

        public TokenInputStream(String label, Tokenizer tokens2) {
            this.tokens = tokens2;
            this.label = label;
        }

        @Override
        public boolean hasNext() {
            block6: {
                if (this.finished) {
                    return false;
                }
                if (this.list != null) {
                    return true;
                }
                try {
                    if (this.tokens.hasNext()) break block6;
                    this.finished = true;
                    return false;
                }
                catch (Exception ex) {
                    this.finished = true;
                    return false;
                }
            }
            this.list = this.buildOneLine();
            if (this.list == null) {
                this.finished = true;
            }
            return this.list != null;
        }

        private List<Token> buildOneLine() {
            ArrayList<Token> tuple = new ArrayList<Token>();
            boolean isDirective = false;
            while (this.tokens.hasNext()) {
                Token token = this.tokens.next();
                if (token.hasType(TokenType.DIRECTIVE)) {
                    isDirective = true;
                }
                if (token.hasType(TokenType.DOT)) {
                    if (tuple.size() > 0 && ((Token)tuple.get(0)).hasType(TokenType.DIRECTIVE)) {
                        this.directive(tuple);
                        tuple.clear();
                        isDirective = false;
                        continue;
                    }
                    return tuple;
                }
                if (!isDirective && token.hasType(TokenType.PREFIXED_NAME)) {
                    String iri2;
                    String ns = this.map.get(token.getImage());
                    if (ns == null) {
                        log.warn("Can't resolve '" + token.toString(false) + "'", (Object)ns);
                        iri2 = "unresolved:" + token.getImage() + ":" + token.getImage2();
                    } else {
                        iri2 = String.valueOf(ns) + token.getImage2();
                    }
                    token.setType(TokenType.IRI);
                    token.setImage(iri2);
                    token.setImage2(null);
                }
                tuple.add(token);
            }
            return tuple;
        }

        private void directive(List<Token> tuple) {
            if (tuple.size() != 3) {
                throw new RiotException("Bad directive: " + tuple);
            }
            String x = tuple.get(0).getImage();
            if (x.equals("prefix")) {
                if (!tuple.get(1).hasType(TokenType.PREFIXED_NAME)) {
                    throw new RiotException("@prefix requires a prefix (found '" + tuple.get(1) + "')");
                }
                if (tuple.get(1).getImage2().length() != 0) {
                    throw new RiotException("@prefix requires a prefix and no suffix (found '" + tuple.get(1) + "')");
                }
                String prefix = tuple.get(1).getImage();
                if (!tuple.get(2).hasType(TokenType.IRI)) {
                    throw new RiotException("@prefix requires an IRI (found '" + tuple.get(1) + "')");
                }
                String iriStr = tuple.get(2).getImage();
                this.map.put(prefix, iriStr);
                return;
            }
            throw new RiotException("Unregcognized directive: " + x);
        }

        @Override
        public List<Token> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            List<Token> r = this.list;
            if (log.isDebugEnabled()) {
                if (this.label != null) {
                    log.debug("<< " + this.label + ": " + r);
                } else {
                    log.debug("<< " + r.toString());
                }
            }
            this.list = null;
            return r;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<List<Token>> iterator() {
            return this;
        }

        @Override
        public void close() {
        }
    }
}

