/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.CharSpace;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.system.StreamOps;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.riot.system.StreamRDFWrapper;
import org.apache.jena.riot.system.StreamRDFWriterFactory;
import org.apache.jena.riot.thrift.BinRDF;
import org.apache.jena.riot.writer.StreamWriterTriX;
import org.apache.jena.riot.writer.WriterStreamRDFBlocks;
import org.apache.jena.riot.writer.WriterStreamRDFFlat;
import org.apache.jena.riot.writer.WriterStreamRDFPlain;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;

public class StreamRDFWriter {
    private static StreamRDFWriterFactory streamWriterFactoryBlocks = new StreamRDFWriterFactory(){

        @Override
        public StreamRDF create(OutputStream output, RDFFormat format) {
            return new WriterStreamRDFBlocks(output);
        }
    };
    private static StreamRDFWriterFactory streamWriterFactoryFlat = new StreamRDFWriterFactory(){

        @Override
        public StreamRDF create(OutputStream output, RDFFormat format) {
            return new WriterStreamRDFFlat(output);
        }
    };
    private static StreamRDFWriterFactory streamWriterFactoryTriplesQuads = new StreamRDFWriterFactory(){

        @Override
        public StreamRDF create(OutputStream output, RDFFormat format) {
            AWriter w = IO.wrapUTF8(output);
            return new WriterStreamRDFPlain(w, CharSpace.UTF8);
        }
    };
    private static StreamRDFWriterFactory streamWriterFactoryTriplesQuadsAscii = new StreamRDFWriterFactory(){

        @Override
        public StreamRDF create(OutputStream output, RDFFormat format) {
            AWriter w = IO.wrapUTF8(output);
            return new WriterStreamRDFPlain(w, CharSpace.ASCII);
        }
    };
    private static StreamRDFWriterFactory streamWriterFactoryThrift = new StreamRDFWriterFactory(){

        @Override
        public StreamRDF create(OutputStream output, RDFFormat format) {
            boolean withValues = RDFFormat.RDF_THRIFT_VALUES.equals(format);
            return BinRDF.streamToOutputStream(output, withValues);
        }
    };
    private static StreamRDFWriterFactory streamWriterFactoryTriX = new StreamRDFWriterFactory(){

        @Override
        public StreamRDF create(OutputStream output, RDFFormat format) {
            return new StreamWriterTriX(output);
        }
    };
    private static StreamRDFWriterFactory streamWriterFactoryNull = new StreamRDFWriterFactory(){

        @Override
        public StreamRDF create(OutputStream output, RDFFormat format) {
            return StreamRDFLib.sinkNull();
        }
    };
    private static WriterRegistry<StreamRDFWriterFactory> registry = new WriterRegistry();

    static {
        StreamRDFWriter.register(Lang.TURTLE, RDFFormat.TURTLE_BLOCKS);
        StreamRDFWriter.register(Lang.TRIG, RDFFormat.TRIG_BLOCKS);
        StreamRDFWriter.register(Lang.NTRIPLES, RDFFormat.NTRIPLES);
        StreamRDFWriter.register(Lang.NQUADS, RDFFormat.NQUADS);
        StreamRDFWriter.register(Lang.RDFTHRIFT, RDFFormat.RDF_THRIFT);
        StreamRDFWriter.register(Lang.TRIX, RDFFormat.TRIX);
        StreamRDFWriter.register(Lang.RDFNULL, RDFFormat.RDFNULL);
        StreamRDFWriter.register(RDFFormat.TURTLE_BLOCKS, streamWriterFactoryBlocks);
        StreamRDFWriter.register(RDFFormat.TURTLE_FLAT, streamWriterFactoryFlat);
        StreamRDFWriter.register(RDFFormat.TRIG_BLOCKS, streamWriterFactoryBlocks);
        StreamRDFWriter.register(RDFFormat.TRIG_FLAT, streamWriterFactoryFlat);
        StreamRDFWriter.register(RDFFormat.NTRIPLES, streamWriterFactoryTriplesQuads);
        StreamRDFWriter.register(RDFFormat.NTRIPLES_UTF8, streamWriterFactoryTriplesQuads);
        StreamRDFWriter.register(RDFFormat.NTRIPLES_ASCII, streamWriterFactoryTriplesQuadsAscii);
        StreamRDFWriter.register(RDFFormat.NQUADS, streamWriterFactoryTriplesQuads);
        StreamRDFWriter.register(RDFFormat.NQUADS_UTF8, streamWriterFactoryTriplesQuads);
        StreamRDFWriter.register(RDFFormat.NQUADS_ASCII, streamWriterFactoryTriplesQuadsAscii);
        StreamRDFWriter.register(RDFFormat.RDF_THRIFT, streamWriterFactoryThrift);
        StreamRDFWriter.register(RDFFormat.RDF_THRIFT_VALUES, streamWriterFactoryThrift);
        StreamRDFWriter.register(RDFFormat.TRIX, streamWriterFactoryTriX);
        StreamRDFWriter.register(RDFFormat.RDFNULL, streamWriterFactoryNull);
    }

    public static void register(Lang lang, RDFFormat format) {
        registry.register(lang, format);
    }

    public static void register(RDFFormat serialization, StreamRDFWriterFactory streamWriterFactory) {
        registry.register(serialization, streamWriterFactory);
    }

    public static RDFFormat defaultSerialization(Lang lang) {
        return registry.defaultSerialization(lang);
    }

    public static StreamRDF getWriterStream(OutputStream output, Lang lang) {
        RDFFormat fmt = registry.choose(lang);
        return StreamRDFWriter.getWriterStream(output, fmt);
    }

    public static StreamRDF getWriterStream(OutputStream output, RDFFormat format) {
        StreamRDFWriterFactory x = registry.get(format);
        if (x == null) {
            throw new RiotException("Failed to find a writer factory for " + format);
        }
        StreamRDF stream = x.create(output, format);
        if (!RDFLanguages.isQuads(format.getLang())) {
            stream = new StreamTriplesOnly(stream);
        }
        return stream;
    }

    public static boolean registered(Lang lang) {
        RDFFormat fmt = registry.defaultSerialization(lang);
        return registry.contains(fmt);
    }

    public static boolean registered(RDFFormat format) {
        return registry.contains(format);
    }

    public static Collection<RDFFormat> registered() {
        return Collections.unmodifiableSet(((WriterRegistry)registry).formatRegistry.keySet());
    }

    public static void write(OutputStream output, Graph graph, Lang lang) {
        RDFFormat fmt = registry.choose(lang);
        StreamRDFWriter.write(output, graph, fmt);
    }

    public static void write(OutputStream output, Graph graph, RDFFormat lang) {
        StreamRDF stream = StreamRDFWriter.getWriterStream(output, lang);
        StreamOps.graphToStream(graph, stream);
    }

    public static void write(OutputStream output, DatasetGraph datasetGraph, Lang lang) {
        RDFFormat fmt = registry.choose(lang);
        StreamRDFWriter.write(output, datasetGraph, fmt);
    }

    public static void write(OutputStream output, DatasetGraph datasetGraph, RDFFormat format) {
        StreamRDF stream = StreamRDFWriter.getWriterStream(output, format);
        StreamOps.datasetToStream(datasetGraph, stream);
    }

    private static class StreamTriplesOnly
    extends StreamRDFWrapper {
        public StreamTriplesOnly(StreamRDF sink) {
            super(sink);
        }

        @Override
        public void quad(Quad quad) {
            if (quad.isTriple() || quad.isDefaultGraph() || quad.isUnionGraph()) {
                this.triple(quad.asTriple());
            }
        }

        @Override
        public void triple(Triple triple) {
            this.other.triple(triple);
        }
    }

    public static class WriterRegistry<T> {
        private Map<RDFFormat, T> formatRegistry = new HashMap<RDFFormat, T>();
        private Map<Lang, RDFFormat> langToFormat = new HashMap<Lang, RDFFormat>();

        public void register(Lang lang, RDFFormat format) {
            this.langToFormat.put(lang, format);
        }

        public void register(RDFFormat serialization, T streamWriterFactory) {
            this.formatRegistry.put(serialization, streamWriterFactory);
        }

        public T get(RDFFormat serialization) {
            return this.formatRegistry.get(serialization);
        }

        public boolean contains(RDFFormat serialization) {
            return this.formatRegistry.containsKey(serialization);
        }

        public RDFFormat defaultSerialization(Lang lang) {
            return this.langToFormat.get(lang);
        }

        public RDFFormat choose(Lang lang) {
            RDFFormat fmt = this.defaultSerialization(lang);
            if (fmt == null) {
                throw new RiotException("No serialization for language " + lang);
            }
            return fmt;
        }
    }
}

