/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.thrift;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.riot.thrift.RiotThriftException;
import org.apache.jena.riot.thrift.ThriftConvert;
import org.apache.jena.riot.thrift.VisitorStreamRowTRDF;
import org.apache.jena.riot.thrift.wire.RDF_ANY;
import org.apache.jena.riot.thrift.wire.RDF_StreamRow;
import org.apache.jena.riot.thrift.wire.RDF_Term;
import org.apache.jena.riot.thrift.wire.RDF_UNDEF;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class TRDF {
    public static final int InputBufferSize = 131072;
    public static final int OutputBufferSize = 131072;
    public static final RDF_ANY ANY = new RDF_ANY();
    public static final RDF_Term tANY = new RDF_Term();
    public static final RDF_UNDEF UNDEF = new RDF_UNDEF();
    public static final RDF_Term tUNDEF = new RDF_Term();

    static {
        tANY.setAny(new RDF_ANY());
        tUNDEF.setUndefined(new RDF_UNDEF());
    }

    public static TProtocol protocol(InputStream in) {
        try {
            if (!(in instanceof BufferedInputStream)) {
                in = new BufferedInputStream(in, 131072);
            }
            TIOStreamTransport transport = new TIOStreamTransport(in);
            ((TTransport)transport).open();
            TProtocol protocol = TRDF.protocol(transport);
            return protocol;
        }
        catch (TException ex) {
            TRDF.exception(ex);
            return null;
        }
    }

    public static TProtocol protocol(OutputStream out) {
        try {
            if (!(out instanceof BufferedOutputStream)) {
                out = new BufferedOutputStream(out, 131072);
            }
            TIOStreamTransport transport = new TIOStreamTransport(out);
            ((TTransport)transport).open();
            TProtocol protocol = TRDF.protocol(transport);
            return protocol;
        }
        catch (TException ex) {
            TRDF.exception(ex);
            return null;
        }
    }

    public static TProtocol protocol(String filename) {
        InputStream in = IO.openFile(filename);
        TProtocol protocol = TRDF.protocol(in);
        return protocol;
    }

    public static TProtocol protocol(TTransport transport) {
        return new TCompactProtocol(transport);
    }

    public static void flush(TProtocol protocol) {
        TRDF.flush(protocol.getTransport());
    }

    public static void flush(TTransport transport) {
        try {
            transport.flush();
        }
        catch (TException ex) {
            TRDF.exception(ex);
        }
    }

    public static void visit(RDF_StreamRow row, VisitorStreamRowTRDF visitor) {
        if (row.isSetTriple()) {
            visitor.visit(row.getTriple());
        } else if (row.isSetQuad()) {
            visitor.visit(row.getQuad());
        } else if (row.isSetPrefixDecl()) {
            visitor.visit(row.getPrefixDecl());
        } else {
            Log.warn(ThriftConvert.class, "visit: Unrecognized: " + row);
        }
    }

    public static void exception(TException ex) {
        throw new RiotThriftException(ex);
    }
}

