/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.op;

import java.util.List;
import java.util.Set;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.Syntax;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpAsQuery;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.op.Op2;
import org.apache.jena.sparql.algebra.op.OpJoin;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.util.NodeIsomorphismMap;

public class OpServiceJoin
extends OpJoin {
    private static final boolean DEBUG = false;
    private Binding slot = null;
    private Op newService;
    private List<Binding> leftMat;
    private Set<Var> commonVars;
    private ExecutionContext qCxt;

    private OpServiceJoin(List<Binding> leftMat, Op leftOp, Op rightOp, Set<Var> commonVars, ExecutionContext qCxt, Op newService) {
        super(leftOp, newService);
        this.newService = newService;
        this.leftMat = leftMat;
        this.commonVars = commonVars;
        this.qCxt = qCxt;
    }

    public static OpServiceJoin create(List<Binding> leftMat, Op leftOp, OpService rightOp, Set<Var> commonVars, ExecutionContext qCxt) {
        String rightOpQueryString = OpAsQuery.asQuery(rightOp).toString();
        StringBuffer newQuery = new StringBuffer();
        int valuesPos = rightOpQueryString.lastIndexOf("}");
        valuesPos = rightOpQueryString.substring(0, valuesPos - 1).lastIndexOf("}");
        newQuery.append(String.valueOf(rightOpQueryString.substring(0, valuesPos)) + " VALUES (");
        for (Var var : commonVars) {
            newQuery.append(var + " ");
        }
        newQuery.append(") {");
        for (Binding b : leftMat) {
            newQuery.append("(");
            for (Var var : commonVars) {
                Node n = b.get(var);
                if (n == null || n.isBlank()) continue;
                if (n.isLiteral()) {
                    String language = n.getLiteralLanguage();
                    String lexicalForm = n.getLiteralLexicalForm();
                    String dataTypeURI = n.getLiteralDatatypeURI();
                    String dataType = n.getLiteralDatatype().toString();
                    newQuery.append("\"" + n.getLiteralLexicalForm() + "\"");
                    if (!language.equals("")) {
                        newQuery.append("@" + language + " ");
                        continue;
                    }
                    newQuery.append("^^<" + n.getLiteralDatatypeURI() + "> ");
                    continue;
                }
                if (!n.isURI()) continue;
                newQuery.append("<" + n.toString() + "> ");
            }
            newQuery.append(")\n");
        }
        newQuery.append("}\n" + rightOpQueryString.substring(valuesPos, rightOpQueryString.length()));
        Query serviceQuery = QueryFactory.create(newQuery.toString(), "", Syntax.syntaxARQ);
        Op newService = Algebra.compile(serviceQuery);
        return new OpServiceJoin(leftMat, leftOp, rightOp, commonVars, qCxt, newService);
    }

    private static List<Binding> all(QueryIterator input) {
        return Iter.toList(input);
    }

    @Override
    public void visit(OpVisitor opVisitor) {
        opVisitor.visit(this);
    }

    @Override
    public boolean equalTo(Op other, NodeIsomorphismMap labelMap) {
        if (!(other instanceof OpJoin)) {
            return false;
        }
        return super.sameArgumentsAs((Op2)other, labelMap);
    }

    @Override
    public String getName() {
        return "OpServiceJoin";
    }

    @Override
    public Op apply(Transform transform, Op left, Op right) {
        return transform.transform(this, left, right);
    }

    @Override
    public Op2 copy(Op left, Op right) {
        return new OpServiceJoin(this.leftMat, left, right, this.commonVars, this.qCxt, this.newService);
    }
}

