/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.optimize;

import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.algebra.optimize.OptimizerMinimal;
import org.apache.jena.sparql.algebra.optimize.OptimizerStd;
import org.apache.jena.sparql.algebra.optimize.Rewrite;
import org.apache.jena.sparql.algebra.optimize.RewriteFactory;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.util.Context;

public class Optimize {
    public static RewriteFactory noOptimizationFactory = context -> op -> op;
    public static RewriteFactory minimalOptimizationFactory = context -> new OptimizerMinimal(context);
    public static RewriteFactory stdOptimizationFactory;
    private static RewriteFactory factory;

    static {
        factory = stdOptimizationFactory = context -> new OptimizerStd(context);
    }

    public static Op optimize(Op op, ExecutionContext execCxt) {
        return Optimize.optimize(op, execCxt.getContext());
    }

    public static Op optimize(Op op, Context context) {
        Rewrite opt = Optimize.decideOptimizer(context);
        return opt.rewrite(op);
    }

    public static void noOptimizer() {
        Optimize.setFactory(noOptimizationFactory);
    }

    public static void basicOptimizer() {
        Optimize.setFactory(minimalOptimizationFactory);
    }

    private static Rewrite decideOptimizer(Context context) {
        RewriteFactory f = (RewriteFactory)context.get(ARQConstants.sysOptimizerFactory);
        if (f == null) {
            f = factory;
        }
        if (f == null) {
            f = stdOptimizationFactory;
        }
        return f.create(context);
    }

    public static void setFactory(RewriteFactory aFactory) {
        factory = aFactory;
    }

    public static RewriteFactory getFactory() {
        return factory;
    }

    public static Op apply(Transform transform, Op op) {
        Op op2 = Transformer.transformSkipService(transform, op);
        if (op2 != op) {
            return op2;
        }
        return op;
    }

    @Deprecated
    public static interface RewriterFactory
    extends RewriteFactory {
    }
}

