/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.table;

import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.algebra.table.TableWriter;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.ResultSetStream;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBase;
import org.apache.jena.sparql.engine.binding.BindingUtils;
import org.apache.jena.sparql.engine.ref.Evaluator;

public abstract class TableBase
implements Table {
    protected TableBase() {
    }

    @Override
    public final void close() {
        this.closeTable();
    }

    protected abstract void closeTable();

    public final Table eval(Evaluator evaluator) {
        return this;
    }

    @Override
    public void addBinding(Binding binding) {
        throw new UnsupportedOperationException("Table.add");
    }

    @Override
    public boolean contains(Binding b) {
        try (QueryIterator qIter = this.iterator(null);){
            while (qIter.hasNext()) {
                Binding b2 = qIter.nextBinding();
                if (!BindingUtils.equals(b, b2)) continue;
                return true;
            }
            return false;
        }
    }

    @Override
    public abstract int size();

    @Override
    public abstract boolean isEmpty();

    @Override
    public ResultSet toResultSet() {
        QueryIterator qIter = this.iterator(null);
        ResultSet rs = new ResultSetStream(this.getVarNames(), null, qIter);
        rs = ResultSetFactory.makeRewindable(rs);
        qIter.close();
        return rs;
    }

    public String toString() {
        return TableWriter.asSSE(this);
    }

    public int hashCode() {
        int hash = 0;
        try (QueryIterator qIter = this.iterator(null);){
            while (qIter.hasNext()) {
                Binding binding = qIter.nextBinding();
                hash ^= binding.hashCode();
            }
            int n = hash;
            return n;
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Table)) {
            return false;
        }
        Table table = (Table)other;
        if (table.size() != this.size()) {
            return false;
        }
        if (!table.getVars().equals(this.getVars())) {
            return false;
        }
        QueryIterator qIter1 = this.iterator(null);
        QueryIterator qIter2 = table.iterator(null);
        try {
            while (qIter1.hasNext()) {
                Binding bind2;
                Binding bind1 = qIter1.nextBinding();
                if (BindingBase.equals(bind1, bind2 = qIter2.nextBinding())) continue;
                return false;
            }
            return true;
        }
        finally {
            qIter1.close();
            qIter2.close();
        }
    }
}

