/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.Objects;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.riot.system.IRIResolver;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.util.PrefixMapping2;

public class Prologue {
    protected boolean seenBaseURI = false;
    protected PrefixMapping prefixMap = null;
    protected IRIResolver resolver = null;

    public Prologue() {
        this.prefixMap = new PrefixMappingImpl();
    }

    public Prologue(PrefixMapping pmap) {
        this.prefixMap = pmap;
        this.resolver = null;
    }

    public Prologue(PrefixMapping pmap, String base) {
        this.prefixMap = pmap;
        this.setBaseURI(base);
    }

    public Prologue(PrefixMapping pmap, IRIResolver resolver) {
        this.prefixMap = pmap;
        this.resolver = resolver;
    }

    public Prologue(Prologue other) {
        this.prefixMap = other.prefixMap;
        this.resolver = other.resolver;
    }

    public Prologue copy() {
        PrefixMappingImpl prefixMap = new PrefixMappingImpl();
        prefixMap.setNsPrefixes(this.prefixMap);
        String baseURI = null;
        if (this.resolver != null) {
            baseURI = this.resolver.getBaseIRIasString();
        }
        return new Prologue((PrefixMapping)prefixMap, baseURI);
    }

    public void usePrologueFrom(Prologue other) {
        this.prefixMap = new PrefixMapping2(other.prefixMap);
        this.seenBaseURI = false;
        if (other.resolver != null) {
            this.resolver = IRIResolver.create(this.getBaseURI());
        }
    }

    public Prologue sub(PrefixMapping newMappings) {
        return this.sub(newMappings, null);
    }

    public Prologue sub(String base) {
        return this.sub(null, base);
    }

    public Prologue sub(PrefixMapping newMappings, String base) {
        PrefixMapping ext = this.getPrefixMapping();
        if (newMappings != null) {
            ext = new PrefixMapping2(ext, newMappings);
        }
        IRIResolver r = this.resolver;
        if (base != null) {
            r = IRIResolver.create(base);
        }
        return new Prologue(ext, r);
    }

    public boolean explicitlySetBaseURI() {
        return this.seenBaseURI;
    }

    public String getBaseURI() {
        if (this.resolver == null) {
            return null;
        }
        return this.resolver.getBaseIRIasString();
    }

    public void setBaseURI(String baseURI) {
        if (baseURI == null) {
            this.seenBaseURI = false;
            this.resolver = null;
            return;
        }
        this.seenBaseURI = true;
        this.resolver = IRIResolver.create(baseURI);
    }

    public void setBaseURI(IRIResolver resolver) {
        if (resolver == null) {
            this.seenBaseURI = false;
            this.resolver = null;
            return;
        }
        this.seenBaseURI = true;
        this.resolver = resolver;
    }

    public void setPrefix(String prefix, String expansion) {
        try {
            String oldExpansion = this.prefixMap.getNsPrefixURI(prefix);
            if (Objects.equals(oldExpansion, expansion)) {
                return;
            }
            if (oldExpansion != null) {
                this.prefixMap.removeNsPrefix(prefix);
            }
            this.prefixMap.setNsPrefix(prefix, expansion);
        }
        catch (PrefixMapping.IllegalPrefixException ex) {
            Log.warn(this, "Illegal prefix mapping(ignored): " + prefix + "=>" + expansion);
        }
    }

    public PrefixMapping getPrefixMapping() {
        return this.prefixMap;
    }

    public void setPrefixMapping(PrefixMapping pmap) {
        this.prefixMap = pmap;
    }

    public String getPrefix(String prefix) {
        return this.prefixMap.getNsPrefixURI(prefix);
    }

    public IRIResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(IRIResolver resolver) {
        this.resolver = resolver;
    }

    public String expandPrefixedName(String prefixed) {
        int colon = prefixed.indexOf(58);
        if (colon < 0) {
            return null;
        }
        String prefix = prefixed.substring(0, colon);
        String uri = this.prefixMap.getNsPrefixURI(prefix);
        if (uri == null) {
            return null;
        }
        return String.valueOf(uri) + prefixed.substring(colon + 1);
    }

    public String shortForm(String uri) {
        return this.prefixMap.shortForm(uri);
    }

    public boolean samePrologue(Prologue other) {
        String base2;
        String base1 = this.explicitlySetBaseURI() ? this.getBaseURI() : null;
        String string = base2 = other.explicitlySetBaseURI() ? other.getBaseURI() : null;
        if (!Objects.equals(base1, base2)) {
            return false;
        }
        if (this.getPrefixMapping() == null && other.getPrefixMapping() == null) {
            return true;
        }
        if (this.getPrefixMapping() == null) {
            return false;
        }
        return this.getPrefixMapping().samePrefixMappingAs(other.getPrefixMapping());
    }

    public static int hash(Prologue prologue) {
        int prime = 31;
        int x = 1;
        x = prologue.seenBaseURI ? 31 * x + prologue.getBaseURI().hashCode() : 1237;
        if (prologue.prefixMap != null) {
            x = 31 * x + prologue.prefixMap.getNsPrefixMap().hashCode();
        }
        return x;
    }
}

