/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.Objects;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryVisitor;
import org.apache.jena.sparql.core.ComparisonException;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.util.NodeIsomorphismMap;

public class QueryCompare
implements QueryVisitor {
    private Query query2;
    private boolean result = true;
    public static boolean PrintMessages = false;

    public static boolean equals(Query query1, Query query2) {
        if (query1 == query2) {
            return true;
        }
        query1.setResultVars();
        query2.setResultVars();
        QueryCompare visitor = new QueryCompare(query1);
        try {
            query2.visit(visitor);
        }
        catch (ComparisonException ex) {
            return false;
        }
        return visitor.isTheSame();
    }

    public QueryCompare(Query query2) {
        this.query2 = query2;
    }

    @Override
    public void startVisit(Query query1) {
    }

    @Override
    public void visitResultForm(Query query1) {
        this.check("Query result form", query1.getQueryType() == this.query2.getQueryType());
    }

    @Override
    public void visitPrologue(Prologue query1) {
        this.check("Prefixes/Base", query1.samePrologue(this.query2));
    }

    @Override
    public void visitSelectResultForm(Query query1) {
        this.check("Not both SELECT queries", this.query2.isSelectType());
        this.check("DISTINCT modifier", query1.isDistinct() == this.query2.isDistinct());
        this.check("SELECT *", query1.isQueryResultStar() == this.query2.isQueryResultStar());
        this.check("Result variables", query1.getProject(), this.query2.getProject());
    }

    @Override
    public void visitConstructResultForm(Query query1) {
        this.check("Not both CONSTRUCT queries", this.query2.isConstructType());
        this.check("CONSTRUCT templates", query1.getConstructTemplate().equalIso(this.query2.getConstructTemplate(), new NodeIsomorphismMap()));
    }

    @Override
    public void visitDescribeResultForm(Query query1) {
        this.check("Not both DESCRIBE queries", this.query2.isDescribeType());
        this.check("Result variables", query1.getResultVars(), this.query2.getResultVars());
        this.check("Result URIs", query1.getResultURIs(), this.query2.getResultURIs());
    }

    @Override
    public void visitAskResultForm(Query query1) {
        this.check("Not both ASK queries", this.query2.isAskType());
    }

    @Override
    public void visitJsonResultForm(Query query2) {
        this.check("Not both JSON queries", this.query2.isJsonType());
    }

    @Override
    public void visitDatasetDecl(Query query1) {
        boolean b1 = Lib.equalsListAsSet(query1.getGraphURIs(), this.query2.getGraphURIs());
        this.check("Default graph URIs", b1);
        boolean b2 = Lib.equalsListAsSet(query1.getNamedGraphURIs(), this.query2.getNamedGraphURIs());
        this.check("Named graph URIs", b2);
    }

    @Override
    public void visitQueryPattern(Query query1) {
        if (query1.getQueryPattern() == null && this.query2.getQueryPattern() == null) {
            return;
        }
        if (query1.getQueryPattern() == null) {
            throw new ComparisonException("Missing pattern");
        }
        if (this.query2.getQueryPattern() == null) {
            throw new ComparisonException("Missing pattern");
        }
        this.check("Pattern", query1.getQueryPattern().equalTo(this.query2.getQueryPattern(), new NodeIsomorphismMap()));
    }

    @Override
    public void visitGroupBy(Query query1) {
        this.check("GROUP BY", query1.getGroupBy(), this.query2.getGroupBy());
    }

    @Override
    public void visitHaving(Query query1) {
        this.check("HAVING", query1.getHavingExprs(), this.query2.getHavingExprs());
    }

    @Override
    public void visitLimit(Query query1) {
        this.check("LIMIT", query1.getLimit() == this.query2.getLimit());
    }

    @Override
    public void visitOrderBy(Query query1) {
        this.check("ORDER BY", query1.getOrderBy(), this.query2.getOrderBy());
    }

    @Override
    public void visitOffset(Query query1) {
        this.check("OFFSET", query1.getOffset() == this.query2.getOffset());
    }

    @Override
    public void visitValues(Query query1) {
        this.check("VALUES/variables", query1.getValuesVariables(), this.query2.getValuesVariables());
        this.check("VALUES/values", query1.getValuesData(), this.query2.getValuesData());
    }

    @Override
    public void finishVisit(Query query1) {
    }

    private void check(String msg, Object obj1, Object obj2) {
        this.check(msg, Objects.equals(obj1, obj2));
    }

    private void check(String msg, boolean b) {
        if (!b) {
            if (PrintMessages && msg != null) {
                System.out.println("Different: " + msg);
            }
            this.result = false;
            throw new ComparisonException(msg);
        }
    }

    public boolean isTheSame() {
        return this.result;
    }
}

