/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.http;

public class HttpContentType {
    String mediaType = null;
    String[] params = null;
    String charset = null;

    public HttpContentType(String s) {
        this.parse(s);
    }

    public HttpContentType(String s, String defaultMediaType, String defaultCharset) {
        this(s);
        if (this.mediaType == null) {
            this.mediaType = defaultMediaType;
        }
        if (this.charset == null) {
            this.charset = defaultCharset;
        }
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public String toString() {
        StringBuilder sbuff = new StringBuilder();
        if (this.mediaType != null) {
            sbuff.append(this.mediaType);
        }
        if (this.charset != null) {
            sbuff.append("; charset=");
            sbuff.append(this.charset);
        }
        return sbuff.toString();
    }

    private void parse(String s) {
        if (s == null) {
            return;
        }
        this.params = s.split(";");
        int i = 0;
        while (i < this.params.length) {
            this.params[i] = this.params[i].trim();
            if (this.params[i].matches("charset\\s*=.*")) {
                int k = this.params[i].indexOf(61);
                this.charset = this.params[i].substring(k + 1).trim();
            } else {
                this.mediaType = this.params[i];
            }
            ++i;
        }
    }
}

