/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.http;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;

public class Params {
    private List<Pair> paramList = new ArrayList<Pair>();
    private Map<String, List<String>> params = new HashMap<String, List<String>>();

    public Params() {
    }

    public Params(Params other) {
        this.merge(other);
    }

    public void merge(Params other) {
        this.params.putAll(other.params);
        this.paramList.addAll(other.paramList);
    }

    public Params addParam(String name, String value) {
        Pair p = new Pair(name, value);
        this.paramList.add(p);
        this.params.computeIfAbsent(name, n -> new ArrayList()).add(value);
        return this;
    }

    public void addParam(String name) {
        this.addParam(name, null);
    }

    public boolean containsParam(String name) {
        return this.params.containsKey(name);
    }

    public String getValue(String name) {
        List<String> x = this.getMV(name);
        if (x == null) {
            return null;
        }
        if (x.size() != 1) {
            throw new MultiValueException("Multiple value (" + x.size() + " when exactly one requested");
        }
        return x.get(0);
    }

    public List<String> getValues(String name) {
        return this.getMV(name);
    }

    public void remove(String name) {
        this.paramList.removeIf(p -> p.getName().equals(name));
        this.params.remove(name);
    }

    public List<Pair> pairs() {
        return this.paramList;
    }

    public int count() {
        return this.paramList.size();
    }

    public List<String> names() {
        return this.paramList.stream().map(Pair::getName).distinct().collect(Collectors.toList());
    }

    public String httpString() {
        return URLEncodedUtils.format(this.paramList, StandardCharsets.UTF_8);
    }

    private List<String> getMV(String name) {
        return this.params.get(name);
    }

    static class MultiValueException
    extends RuntimeException {
        MultiValueException(String msg) {
            super(msg);
        }
    }

    public static class Pair
    extends org.apache.jena.atlas.lib.Pair<String, String>
    implements NameValuePair {
        public Pair(String name, String value) {
            super(name, value);
        }

        @Override
        public String getName() {
            return (String)this.getLeft();
        }

        @Override
        public String getValue() {
            return (String)this.getRight();
        }
    }
}

