/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.iterator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.jena.atlas.data.BagFactory;
import org.apache.jena.atlas.data.DistinctDataBag;
import org.apache.jena.atlas.data.ThresholdPolicy;
import org.apache.jena.atlas.data.ThresholdPolicyFactory;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.SortCondition;
import org.apache.jena.riot.system.SerializationFactoryFinder;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingComparator;
import org.apache.jena.sparql.engine.binding.BindingProjectNamed;
import org.apache.jena.sparql.engine.iterator.QueryIter1;

public class QueryIterDistinct
extends QueryIter1 {
    private long memThreshold = Long.MAX_VALUE;
    DistinctDataBag<Binding> db = null;
    private Iterator<Binding> iterator = null;
    private Set<Binding> seen = new HashSet<Binding>();
    private Binding slot = null;

    public QueryIterDistinct(QueryIterator qIter, ExecutionContext execCxt) {
        super(qIter, execCxt);
        if (execCxt != null) {
            this.memThreshold = execCxt.getContext().getLong(ARQ.spillToDiskThreshold, this.memThreshold);
            if (this.memThreshold < 0L) {
                throw new ARQException("BAd spillToDiskThreshold: " + this.memThreshold);
            }
        }
    }

    @Override
    protected boolean hasNextBinding() {
        if (this.slot != null) {
            return true;
        }
        if (this.iterator != null) {
            return this.iterator.hasNext();
        }
        if ((long)this.seen.size() < this.memThreshold) {
            Binding b = this.getInputNextUnseen();
            if (b == null) {
                return false;
            }
            this.seen.add(b);
            this.slot = b;
            return true;
        }
        this.loadDataBag();
        this.iterator = this.db.iterator();
        return this.iterator.hasNext();
    }

    private void loadDataBag() {
        Binding b;
        ThresholdPolicy policy = ThresholdPolicyFactory.policyFromContext(super.getExecContext().getContext());
        BindingComparator comparator = new BindingComparator(new ArrayList<SortCondition>(), super.getExecContext());
        this.db = BagFactory.newDistinctBag(policy, SerializationFactoryFinder.bindingSerializationFactory(), comparator);
        while ((b = this.getInputNextUnseen()) != null) {
            this.db.add(b);
        }
    }

    private Binding getInputNextUnseen() {
        while (this.getInput().hasNext()) {
            Binding b = this.getInputNext();
            if (this.seen.contains(b)) continue;
            return b;
        }
        return null;
    }

    private Binding getInputNext() {
        Binding b = (Binding)this.getInput().next();
        b = new BindingProjectNamed(b);
        return b;
    }

    @Override
    protected Binding moveToNextBinding() {
        if (this.slot != null) {
            Binding b = this.slot;
            this.slot = null;
            return b;
        }
        if (this.iterator != null) {
            Binding b = this.iterator.next();
            return b;
        }
        throw new InternalErrorException();
    }

    @Override
    protected void closeSubIterator() {
        if (this.db != null) {
            this.iterator = null;
            this.db.close();
        }
        this.db = null;
    }

    @Override
    protected void requestSubCancel() {
    }
}

