/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.main.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.SingletonIterator;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.op.OpGraph;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIterAssignVarValue;
import org.apache.jena.sparql.engine.iterator.QueryIterRepeatApply;
import org.apache.jena.sparql.engine.iterator.QueryIterSingleton;
import org.apache.jena.sparql.engine.iterator.QueryIterSub;
import org.apache.jena.sparql.engine.main.QC;

public class QueryIterGraph
extends QueryIterRepeatApply {
    protected OpGraph opGraph;

    public QueryIterGraph(QueryIterator input, OpGraph opGraph, ExecutionContext context) {
        super(input, context);
        this.opGraph = opGraph;
    }

    @Override
    protected QueryIterator nextStage(Binding outerBinding) {
        DatasetGraph ds = this.getExecContext().getDataset();
        Iterator<Node> graphNameNodes = QueryIterGraph.makeSources(ds, outerBinding, this.opGraph.getNode());
        QueryIterGraphInner current = new QueryIterGraphInner(outerBinding, graphNameNodes, this.opGraph, this.getExecContext());
        return current;
    }

    private static Node resolve(Binding b, Node n) {
        if (!n.isVariable()) {
            return n;
        }
        return b.get(Var.alloc(n));
    }

    protected static Iterator<Node> makeSources(DatasetGraph data, Binding b, Node graphVar) {
        Node n2 = QueryIterGraph.resolve(b, graphVar);
        if (n2 != null && n2.isLiteral()) {
            return Iter.nullIterator();
        }
        if (n2 == null) {
            return data.listGraphNodes();
        }
        return new SingletonIterator<Node>(n2);
    }

    protected static class QueryIterGraphInner
    extends QueryIterSub {
        protected final Binding parentBinding;
        protected final Iterator<Node> graphNames;
        protected final OpGraph opGraph;
        protected final Op opSubstituted;

        protected QueryIterGraphInner(Binding parent, Iterator<Node> graphNames, OpGraph opGraph, ExecutionContext execCxt) {
            super(null, execCxt);
            this.parentBinding = parent;
            this.graphNames = graphNames;
            this.opGraph = opGraph;
            this.opSubstituted = Substitute.substitute(opGraph.getSubOp(), parent);
        }

        @Override
        protected boolean hasNextBinding() {
            do {
                if (this.iter == null) {
                    this.iter = this.nextIterator();
                }
                if (this.iter == null) {
                    return false;
                }
                if (this.iter.hasNext()) {
                    return true;
                }
                this.iter.close();
                this.iter = this.nextIterator();
            } while (this.iter != null);
            return false;
        }

        @Override
        protected Binding moveToNextBinding() {
            if (this.iter == null) {
                throw new NoSuchElementException(String.valueOf(Lib.className(this)) + ".moveToNextBinding");
            }
            return this.iter.nextBinding();
        }

        protected QueryIterator nextIterator() {
            while (this.graphNames.hasNext()) {
                Node gn = this.graphNames.next();
                QueryIterator iter = this.buildIterator(gn);
                if (iter == null) continue;
                return iter;
            }
            return null;
        }

        private QueryIterator buildIterator(Node gn) {
            QueryIterator qIter = QueryIterGraphInner.buildIterator(this.parentBinding, gn, this.opSubstituted, this.getExecContext());
            if (qIter == null) {
                return null;
            }
            if (Var.isVar(this.opGraph.getNode())) {
                Var v = Var.alloc(this.opGraph.getNode());
                qIter = new QueryIterAssignVarValue(qIter, v, gn, this.getExecContext());
            }
            return qIter;
        }

        protected static QueryIterator buildIterator(Binding binding, Node graphNode, Op opExec, ExecutionContext outerCxt) {
            boolean syntheticGraph;
            if (!graphNode.isURI() && !graphNode.isBlank()) {
                throw new ARQInternalErrorException("QueryIterGraphInner.buildIterator: Not a URI or blank node: " + graphNode);
            }
            boolean bl = syntheticGraph = Quad.isDefaultGraph(graphNode) || Quad.isUnionGraph(graphNode);
            if (!syntheticGraph && !outerCxt.getDataset().containsGraph(graphNode)) {
                return null;
            }
            Graph g = outerCxt.getDataset().getGraph(graphNode);
            if (g == null) {
                return null;
            }
            ExecutionContext cxt2 = new ExecutionContext(outerCxt, g);
            QueryIterSingleton subInput = QueryIterSingleton.create(binding, cxt2);
            return QC.execute(opExec, subInput, cxt2);
        }

        @Override
        protected void requestSubCancel() {
        }

        @Override
        protected void closeSubIterator() {
        }
    }
}

