/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.optimizer.reorder;

import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderProc;

public class ReorderProcIndexes
implements ReorderProc {
    private int[] indexes;

    public ReorderProcIndexes(int[] indexes) {
        this.indexes = indexes;
    }

    @Override
    public BasicPattern reorder(BasicPattern bgp) {
        if (this.indexes.length != bgp.size()) {
            String str2 = String.format("Expected size = %d : actual basic pattern size = %d", this.indexes.length, bgp.size());
            Log.error(this, str2);
            throw new ARQException(str2);
        }
        BasicPattern bgp2 = new BasicPattern();
        int[] nArray = this.indexes;
        int n = this.indexes.length;
        int n2 = 0;
        while (n2 < n) {
            int idx = nArray[n2];
            Triple t = bgp.get(idx);
            bgp2.add(t);
            ++n2;
        }
        return bgp2;
    }

    public String toString() {
        String x = "";
        String sep = "";
        int[] nArray = this.indexes;
        int n = this.indexes.length;
        int n2 = 0;
        while (n2 < n) {
            int idx = nArray[n2];
            x = String.valueOf(x) + sep + idx;
            sep = ", ";
            ++n2;
        }
        return x;
    }
}

