/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprNode;
import org.apache.jena.sparql.expr.FunctionLabel;
import org.apache.jena.sparql.serializer.SerializationContext;

public abstract class ExprFunction
extends ExprNode {
    protected FunctionLabel funcSymbol;
    protected String opSign;

    protected ExprFunction(String fName) {
        this.funcSymbol = new FunctionLabel(fName);
        this.opSign = null;
    }

    protected ExprFunction(String fName, String opSign) {
        this(fName);
        this.opSign = opSign;
    }

    public abstract Expr getArg(int var1);

    public abstract int numArgs();

    public List<Expr> getArgs() {
        ArrayList<Expr> argList = new ArrayList<Expr>(this.numArgs());
        int i = 1;
        while (i <= this.numArgs()) {
            argList.add(this.getArg(i));
            ++i;
        }
        return argList;
    }

    @Override
    public boolean isFunction() {
        return true;
    }

    @Override
    public ExprFunction getFunction() {
        return this;
    }

    @Override
    public int hashCode() {
        return this.funcSymbol.hashCode() ^ this.numArgs();
    }

    @Override
    public boolean equals(Expr other, boolean bySyntax) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        ExprFunction ex = (ExprFunction)other;
        if (!this.funcSymbol.equals(ex.funcSymbol)) {
            return false;
        }
        if (this.numArgs() != ex.numArgs()) {
            return false;
        }
        int i = 1;
        while (i <= this.numArgs()) {
            Expr a2;
            Expr a1 = this.getArg(i);
            if (!a1.equals(a2 = ex.getArg(i), bySyntax)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getFunctionPrintName(SerializationContext cxt) {
        return this.funcSymbol.getSymbol();
    }

    public String getFunctionName(SerializationContext cxt) {
        return this.funcSymbol.getSymbol();
    }

    public FunctionLabel getFunctionSymbol() {
        return this.funcSymbol;
    }

    public String getFunctionIRI() {
        return null;
    }

    public String getOpName() {
        return this.opSign;
    }
}

