/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprFunction;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprVisitor;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.graph.NodeTransform;

public abstract class ExprFunctionN
extends ExprFunction {
    protected ExprList args = null;

    protected ExprFunctionN(String fName, Expr ... args) {
        this(fName, ExprFunctionN.argList(args));
    }

    protected ExprFunctionN(String fName, ExprList args) {
        super(fName);
        this.args = args;
    }

    private static ExprList argList(Expr[] args) {
        ExprList exprList = new ExprList();
        Expr[] exprArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Expr e2 = exprArray[n2];
            if (e2 != null) {
                exprList.add(e2);
            }
            ++n2;
        }
        return exprList;
    }

    @Override
    public Expr getArg(int i) {
        if (--i >= this.args.size()) {
            return null;
        }
        return this.args.get(i);
    }

    @Override
    public int numArgs() {
        return this.args.size();
    }

    @Override
    public List<Expr> getArgs() {
        return this.args.getList();
    }

    @Override
    public Expr copySubstitute(Binding binding) {
        ExprList newArgs = new ExprList();
        int i = 1;
        while (i <= this.numArgs()) {
            Expr e2 = this.getArg(i);
            e2 = e2.copySubstitute(binding);
            newArgs.add(e2);
            ++i;
        }
        return this.copy(newArgs);
    }

    @Override
    public Expr applyNodeTransform(NodeTransform transform) {
        ExprList newArgs = new ExprList();
        int i = 1;
        while (i <= this.numArgs()) {
            Expr e2 = this.getArg(i);
            e2 = e2.applyNodeTransform(transform);
            newArgs.add(e2);
            ++i;
        }
        return this.copy(newArgs);
    }

    protected NodeValue evalSpecial(Binding binding, FunctionEnv env) {
        return null;
    }

    @Override
    public final NodeValue eval(Binding binding, FunctionEnv env) {
        NodeValue s = this.evalSpecial(binding, env);
        if (s != null) {
            return s;
        }
        ArrayList<NodeValue> argsEval = new ArrayList<NodeValue>();
        int i = 1;
        while (i <= this.numArgs()) {
            NodeValue x = ExprFunctionN.eval(binding, env, this.getArg(i));
            argsEval.add(x);
            ++i;
        }
        return this.eval(argsEval, env);
    }

    public NodeValue eval(List<NodeValue> args, FunctionEnv env) {
        return this.eval(args);
    }

    public abstract NodeValue eval(List<NodeValue> var1);

    public abstract Expr copy(ExprList var1);

    @Override
    public void visit(ExprVisitor visitor) {
        visitor.visit(this);
    }

    public Expr apply(ExprTransform transform, ExprList exprList) {
        return transform.transform(this, exprList);
    }
}

