/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.jena.sparql.algebra.walker.Walker;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.E_LogicalAnd;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprBuild;
import org.apache.jena.sparql.expr.ExprVars;
import org.apache.jena.sparql.expr.ExprVisitor;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.util.Context;

public class ExprList
implements Iterable<Expr> {
    private final List<Expr> expressions;
    public static final ExprList emptyList = new ExprList(Collections.emptyList());

    public static ExprList copy(ExprList other) {
        return new ExprList(other);
    }

    public static ExprList create(Collection<Expr> exprs) {
        ExprList exprList = new ExprList();
        exprs.forEach(exprList::add);
        return exprList;
    }

    public ExprList() {
        this.expressions = new ArrayList<Expr>();
    }

    private ExprList(ExprList other) {
        this();
        this.expressions.addAll(other.expressions);
    }

    public ExprList(Expr expr) {
        this();
        this.expressions.add(expr);
    }

    public ExprList(List<Expr> x) {
        this.expressions = x;
    }

    public boolean isSatisfied(Binding binding, ExecutionContext execCxt) {
        for (Expr expr : this.expressions) {
            if (expr.isSatisfied(binding, execCxt)) continue;
            return false;
        }
        return true;
    }

    public Expr get(int idx) {
        return this.expressions.get(idx);
    }

    public int size() {
        return this.expressions.size();
    }

    public boolean isEmpty() {
        return this.expressions.isEmpty();
    }

    public ExprList subList(int fromIdx, int toIdx) {
        return new ExprList(this.expressions.subList(fromIdx, toIdx));
    }

    public ExprList tail(int fromIdx) {
        return this.subList(fromIdx, this.expressions.size());
    }

    public Set<Var> getVarsMentioned() {
        HashSet<Var> x = new HashSet<Var>();
        this.varsMentioned(x);
        return x;
    }

    @Deprecated
    public void varsMentioned(Collection<Var> acc) {
        for (Expr expr : this.expressions) {
            ExprVars.varsMentioned(acc, expr);
        }
    }

    public ExprList applyNodeTransform(NodeTransform transform) {
        ExprList x = new ExprList();
        for (Expr e2 : this.expressions) {
            x.add(e2.applyNodeTransform(transform));
        }
        return x;
    }

    public ExprList copySubstitute(Binding binding) {
        ExprList x = new ExprList();
        for (Expr expr : this.expressions) {
            expr = expr.copySubstitute(binding);
            x.add(expr);
        }
        return x;
    }

    public void addAll(ExprList exprs) {
        this.expressions.addAll(exprs.getList());
    }

    public void add(Expr expr) {
        this.expressions.add(expr);
    }

    public List<Expr> getList() {
        return Collections.unmodifiableList(this.expressions);
    }

    public List<Expr> getListRaw() {
        return this.expressions;
    }

    @Override
    public Iterator<Expr> iterator() {
        return this.expressions.iterator();
    }

    public void prepareExprs(Context context) {
        ExprBuild build = new ExprBuild(context);
        for (Expr expr : this.expressions) {
            Walker.walk(expr, (ExprVisitor)build);
        }
    }

    public String toString() {
        return this.expressions.toString();
    }

    public int hashCode() {
        return this.expressions.hashCode();
    }

    public boolean equals(ExprList other, boolean bySyntax) {
        if (this == other) {
            return true;
        }
        if (this.expressions.size() != other.expressions.size()) {
            return false;
        }
        int i = 0;
        while (i < this.expressions.size()) {
            Expr e2;
            Expr e1 = this.expressions.get(i);
            if (!e1.equals(e2 = other.expressions.get(i), bySyntax)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ExprList)) {
            return false;
        }
        ExprList exprs = (ExprList)other;
        return this.equals((ExprList)other, false);
    }

    public static ExprList splitConjunction(ExprList exprList1) {
        ExprList exprList2 = new ExprList();
        for (Expr expr : exprList1) {
            ExprList.split(exprList2, expr);
        }
        return exprList2;
    }

    private static ExprList splitConjunction(Expr expr) {
        ExprList exprList = new ExprList();
        ExprList.split(exprList, expr);
        return exprList;
    }

    private static void split(ExprList exprList, Expr expr) {
        while (expr instanceof E_LogicalAnd) {
            E_LogicalAnd x = (E_LogicalAnd)expr;
            Expr left = x.getArg1();
            Expr right = x.getArg2();
            ExprList.split(exprList, left);
            expr = right;
        }
        exprList.add(expr);
    }
}

