/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.RegexEngine;

public class RegexJava
implements RegexEngine {
    private Pattern regexPattern;

    public RegexJava(String pattern, String flags) {
        this.regexPattern = RegexJava.makePattern("Regex", pattern, flags);
    }

    @Override
    public boolean match(String s) {
        Matcher m = this.regexPattern.matcher(s);
        return m.find();
    }

    public static Pattern makePattern(String label, String patternStr, String flags) {
        try {
            int mask = 0;
            if (flags != null) {
                mask = RegexJava.makeMask(flags);
                if (flags.contains("q")) {
                    patternStr = Pattern.quote(patternStr);
                }
            }
            return Pattern.compile(patternStr, mask);
        }
        catch (PatternSyntaxException pEx) {
            throw new ExprEvalException(String.valueOf(label) + " pattern exception: " + pEx);
        }
    }

    public static int makeMask(String modifiers) {
        if (modifiers == null) {
            return 0;
        }
        int newMask = 0;
        int i = 0;
        while (i < modifiers.length()) {
            switch (modifiers.charAt(i)) {
                case 'i': {
                    newMask |= 0x40;
                    newMask |= 2;
                    break;
                }
                case 'm': {
                    newMask |= 8;
                    break;
                }
                case 's': {
                    newMask |= 0x20;
                    break;
                }
                case 'q': {
                    break;
                }
                default: {
                    throw new ExprEvalException("Unsupported flag in regex modifiers: " + modifiers.charAt(i));
                }
            }
            ++i;
        }
        return newMask;
    }
}

