/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function;

import java.util.List;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.query.QueryBuildException;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionBase;

public abstract class FunctionBase3
extends FunctionBase {
    @Override
    public void checkBuild(String uri, ExprList args) {
        if (args.size() != 3) {
            throw new QueryBuildException("Function '" + Lib.className(this) + "' takes three arguments");
        }
    }

    @Override
    public final NodeValue exec(List<NodeValue> args) {
        if (args == null) {
            throw new ARQInternalErrorException(String.valueOf(Lib.className(this)) + ": Null args list");
        }
        if (args.size() != 3) {
            throw new ExprEvalException(String.valueOf(Lib.className(this)) + ": Wrong number of arguments: Wanted 3, got " + args.size());
        }
        NodeValue v1 = args.get(0);
        NodeValue v2 = args.get(1);
        NodeValue v3 = args.get(2);
        return this.exec(v1, v2, v3);
    }

    public abstract NodeValue exec(NodeValue var1, NodeValue var2, NodeValue var3);
}

