/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function.js;

import javax.script.ScriptException;
import org.apache.jena.atlas.lib.Pool;
import org.apache.jena.atlas.lib.PoolBase;
import org.apache.jena.atlas.lib.PoolSync;
import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.function.js.JSEngine;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;

public class EnvJavaScript {
    public static Symbol symJavaScriptFunctions = ARQ.symJavaScriptFunctions;
    public static Symbol symJavaScriptLibFile = ARQ.symJavaScriptLibFile;
    private final String scriptLib;
    private final String scriptLibFile;
    private static EnvJavaScript global = null;
    private Pool<JSEngine> pool = PoolSync.create(new PoolBase());

    public static EnvJavaScript create(Context context) {
        return new EnvJavaScript(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EnvJavaScript get() {
        if (global != null) return global;
        Class<EnvJavaScript> clazz = EnvJavaScript.class;
        synchronized (EnvJavaScript.class) {
            Context context = ARQ.getContext();
            if (!context.isDefined(symJavaScriptFunctions) && !context.isDefined(symJavaScriptLibFile)) return global;
            global = EnvJavaScript.create(ARQ.getContext());
            // ** MonitorExit[var0] (shouldn't be in output)
            return global;
        }
    }

    public static void reset() {
        EnvJavaScript.reset(ARQ.getContext());
    }

    public static void reset(Context context) {
        global = EnvJavaScript.create(context);
    }

    private EnvJavaScript(Context context) {
        this.scriptLib = context.getAsString(symJavaScriptFunctions);
        this.scriptLibFile = context.getAsString(symJavaScriptLibFile);
        this.pool.put(this.build());
    }

    private JSEngine build() {
        return new JSEngine(this.scriptLib, this.scriptLibFile);
    }

    private JSEngine getEngine() {
        JSEngine engine = this.pool.get();
        if (engine == null) {
            engine = new JSEngine(this.scriptLib, this.scriptLibFile);
        }
        return engine;
    }

    private EnvJavaScript(String functions, String functionLibFile) {
        this.scriptLib = functions;
        this.scriptLibFile = functionLibFile;
    }

    public Object call(String functionName, Object[] args) throws NoSuchMethodException, ScriptException {
        JSEngine engine = this.getEngine();
        try {
            Object object = engine.call(functionName, args);
            return object;
        }
        finally {
            this.pool.put(engine);
        }
    }
}

